/* SessionFactory.as */

package gov.va.med.edp.factory
{
    import gov.va.med.edp.model.TrackingModelLocator;
    import gov.va.med.edp.util.Vista;
    import gov.va.med.edp.vo.LookupStringVO;
    import gov.va.med.edp.vo.LookupVO;
    import gov.va.med.edp.vo.SessionVO;
    
    import mx.collections.ArrayCollection;
    import mx.utils.StringUtil;

    //import mx.controls.Alert;
	
	/** 
	 * Factory for generating session related objects.
	 */ 
    public class SessionFactory
    {
		
		/**
		 *   Constructor.
		 */
		public function SessionFactory() 
		{
		}
		
        /*
        expects XML node:
        <anyRoot>
            <user duz="99" site="99" siteNm="a name" area="99" areaName="a name" />
        </anyRoot>
        */
		
		// Only want 1 instance of the cpe view
		private static var cpeAdded:Boolean = false;
		private static var wsAdded:Boolean = false;

		public var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/** 
		 * Build a session item from xml data.
		 * @param xml XML data to build. 
		 * 
		 * @return SessionVO object. 
		 */ 			
        public static function buildSessionFromXML(xml:XML):SessionVO
        {
        	//since this is the ONLY call that does not get added to the debug tool..tracing xml here for debug mode..
        	trace ("Session XML\n" + xml);
            var sessionVO:SessionVO = new SessionVO();
            sessionVO.duz = xml.user[0].@duz;
            sessionVO.site = xml.user[0].@station;
            sessionVO.siteName = xml.user[0].@siteNm;
            sessionVO.area = xml.user[0].@area;
            sessionVO.areaName = xml.user[0].@areaNm;
            sessionVO.baseTime = new Date();
            sessionVO.siteTimeFM = xml.user[0].@time;
            sessionVO.siteTime = Vista.FMtoDate(sessionVO.siteTimeFM);

            var timeOut:int = xml.user[0].@timeOut;
            if (timeOut > 0) sessionVO.timeOut = timeOut;
            var countDown:int = xml.user[0].@countDown;
            if (countDown > 0) sessionVO.countDown = countDown;

			sessionVO.showAdhocReport = (xml.user[0].@rptAdhoc == '1');
            sessionVO.canExport = (xml.user[0].@rptExport == "1")
            sessionVO.showProviderReport = (xml.user[0].@rptProvider == "1");
            sessionVO.showPatientCrossReferenceReport = (xml.user[0].@rptXRef == "1");
            sessionVO.debugEnabled = (xml.user[0].@progMode == "1");

            sessionVO.serverPackageVersion = xml.user[0].@version;
			
			sessionVO.roleID = xml.user[0].@roleID;
			sessionVO.roleName = xml.user[0].@roleName;
			sessionVO.roleAbbr = xml.user[0].@roleAbbr;
			sessionVO.defaultWorksheet = xml.user[0].@defaultWorksheet;
			sessionVO.defaultBoard = xml.user[0].@defaultBoard;
			//sessionVO.defaultRoom = xml.user[0].@defaultRoom;
			//Alert.show("Session : " + sessionVO.toString());

            return sessionVO;
        }
        
		/** 
		 * Build a lookup item from xml data.
		 * expects XML node:  <anyNode data="internalID" label="externalName" />
		 * @param xml XML data to build. 
		 * 
		 * @return LookupVO object. 
		 */ 	
        public static function buildLookupItemFromXML(xml:XML):LookupVO
        {
        	var lookupVO:LookupVO = new LookupVO();						
			lookupVO.data = Number(xml.@data);
			lookupVO.label = xml.@label;
			lookupVO.abbr = xml.@abbr;				
			
        	return lookupVO;
        }
        
		private static function isCPEView(data:Number):Boolean
		{
			var isCPE:Boolean = false;
			
			if((data == TrackingModelLocator.VIEW_APP_SIGN_IN) || 
				(data == TrackingModelLocator.VIEW_APP_TRIAGE) ||
				(data == TrackingModelLocator.VIEW_APP_DISPOSITION) ||
				(data == TrackingModelLocator.VIEW_APP_UPDATE)) {
				isCPE = true;
			}
			
			return isCPE;			
		}
		
        /*
        expects xml to be: 
        <anyRoot>
	      	<anyNode data="internalID" label="externalName" />
    	   	<anyNode data="internalID" label="externalName" />
    	   	...
    	</anyRoot>
    	*/
		/** 
		 * Build a lookup list from xml data.
		 * 
		 * @param nodeList XML nodelist to build. 
		 * 
		 * @return ArrayCollection of built objects. 
		 */ 		
        public static function buildLookupListFromXML(nodeList: XMLList): ArrayCollection
        {		
        	var lookupList:ArrayCollection = new ArrayCollection();
        				
			for each (var item: XML in nodeList) {				
				var lookupVO:LookupVO = buildLookupItemFromXML(item);				
				lookupList.addItem(lookupVO);				
        	}
        	return lookupList;
        }
		
		/** 
		 * Build a app view list from xml data.
		 * 
		 * @param nodeList XML nodelist to build. 
		 * 
		 * @return ArrayCollection of built objects. 
		 */ 		
		public static function buildAppViewListFromXML(nodeList: XMLList): ArrayCollection
		{		
			var lookupList:ArrayCollection = new ArrayCollection();
								
			for each (var item: XML in nodeList) {
				
				var lookupVO:LookupVO = new LookupVO();
				
				var data:Number = Number(item.@data);
				
				if(isCPEView(data)) {			
					lookupVO.data = TrackingModelLocator.VIEW_APP_CPE;
					lookupVO.label = "CPE";
					lookupVO.abbr = "intro";
					if(!cpeAdded){ // Add the cpe view once
						lookupList.addItem(lookupVO);
						cpeAdded = true;
					}	
				} else {
					lookupVO = buildLookupItemFromXML(item);
					lookupList.addItem(lookupVO);
				}
				
			}
		
			return lookupList;
		}
		
		
		/** 
		 * Build a lookup string from xml data.
		 * 
		 * @param nodeList XML nodelist to build. 
		 * 
		 * @return ArrayCollection of built objects. 
		 */ 		        
        public static function buildLookupStringListFromXML(nodeList: XMLList): ArrayCollection
        {
        	var list: ArrayCollection = new ArrayCollection();
        	for each (var item: XML in nodeList) {
        		var lookupStringVO: LookupStringVO = new LookupStringVO();
        		lookupStringVO.data = item.@data;
        		lookupStringVO.label = item.@label;
        		lookupStringVO.reference = item.@ref;
        		list.addItem(lookupStringVO);
        	}
        	return list;
        }
		
		/** 
		 * Build a lookup string from xml bed data, ignoring the bed labelled "None"
		 * 
		 * @param nodeList XML nodelist to build. 
		 * 
		 * @return ArrayCollection of built objects. 
		 */ 		        
        public static function buildLookupBedListFromXML(nodeList: XMLList): ArrayCollection
        {
        	var list: ArrayCollection = new ArrayCollection();
        	for each (var item: XML in nodeList) {
				if (item.@label != "None") {
        		var lookupStringVO: LookupStringVO = new LookupStringVO();
        		lookupStringVO.data = item.@data;
        		lookupStringVO.label = item.@label;
				lookupStringVO.label = StringUtil.trim(lookupStringVO.label);
        		lookupStringVO.reference = item.@ref;
        		list.addItem(lookupStringVO);
				}
        	}
        	return list;
        }
    }
}