/* ReportFactory.as */

package gov.va.med.edp.factory
{
	import gov.va.med.edp.model.reports.MissedOpReport;
	import gov.va.med.edp.util.Vista;
	import gov.va.med.edp.vo.reports.AcuityVO;
	import gov.va.med.edp.vo.reports.AveragesVO;
	import gov.va.med.edp.vo.reports.BVACLogEntryVO;
	import gov.va.med.edp.vo.reports.CustomReportVO;
	import gov.va.med.edp.vo.reports.EdStaffVO;
	import gov.va.med.edp.vo.reports.OrdersByAcuityVO;
	import gov.va.med.edp.vo.reports.PatientExposureVO;
	import gov.va.med.edp.vo.reports.PatientRemovedInErrorVO;
	import gov.va.med.edp.vo.reports.PatientXRefVO;
	import gov.va.med.edp.vo.reports.ProviderShiftVO;
	import gov.va.med.edp.vo.reports.ProviderVO;
	import gov.va.med.edp.vo.reports.PtDemographicsVO;
	import gov.va.med.edp.vo.reports.PtIntakeVO;
	import gov.va.med.edp.vo.reports.ReportLogEntryVO;
	import gov.va.med.edp.vo.reports.ShiftCategoryVO;
	import gov.va.med.edp.vo.reports.ShiftReportColumnVO;
	import gov.va.med.edp.vo.reports.SummaryReportVO;
	import gov.va.med.edp.vo.reports.adhoc.AdhocReportElementVO;
	import gov.va.med.edp.vo.reports.adhoc.AdhocReportRoleVO;
	import gov.va.med.edp.vo.reports.adhoc.AdhocReportVO;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	
	/**
	 * Defines reports based on user selection
	 * 
	 *  <p>added patient demographic viewing option
	 *  <p>changed labs to labs_ordered and labs_resulted  -  J Lemaire 9/24/11
	 */
	public class ReportFactory
	{
		/**
		 * creates an array missed disposition code list  from XML list 
		 * @param nodeList
		 * @return 
		 * 
		 */
		public static function buildMissedOpDispositionCodes(missedOpReport: MissedOpReport, xmlList:XMLList): void
		{
			for each (var item:XML in xmlList) {
				missedOpReport.AMA = item.@AMA;
				missedOpReport.eloped = item.@E;
				missedOpReport.leftWithoutTreatment = item.@L;
			}
		}
		/**
		 * creates an Summery report and  SummaryReportVO list  from XML list 
		 * @param nodeList
		 * @return 
		 * 
		 */
		public static function buildSummaryVOFromXML(nodeList:XMLList): SummaryReportVO
		{
			var summaryReportVO: SummaryReportVO = new SummaryReportVO();
			//TODO: Mel needs to Change XML Structure.
			//This structure doesn't fit very well..  
			
			for each (var item:XML in nodeList) {
				if (item.@type == "All Patients"){
					summaryReportVO.avgAllAdmitDecisionTime = item.@avgAdmDec;
					summaryReportVO.avgAllEDVisitTime = item.@avgTime;
					summaryReportVO.totAllEDVisits = item.@total;
					summaryReportVO.totAllVisitOver6Hrs = item.@num6hr;
					summaryReportVO.totAllVisitOver23Hrs = item.@num23hr;
					summaryReportVO.numAdmittedToObservation = item.@numObs;
				} else if (item.@type == "Not VA Admitted"){
					summaryReportVO.totNotVaAdmittedVisits = item.@total;
					summaryReportVO.avgNotVaAdmittedVisitTime = item.@avgTime;
				} else if (item.@type == "VA Admitted"){
					summaryReportVO.totVaAdmittedEDVisits = item.@total;        		
					summaryReportVO.totVaAdmittedDelayOver6Hrs = item.@num6hr;
					summaryReportVO.avgVaAdmittedDelayTime = item.@avgAdmDel;
					summaryReportVO.avgVaAdmittedDecisionTime = item.@avgAdmDec;
					summaryReportVO.numVaAdmittedDelayOver6Hrs = item.@numAdmDel6hr;
				}
			}
			return summaryReportVO;
		}
		
		/**
		 * creates an array patient reference list  from XML list 
		 * @param nodeList
		 * @return 
		 * 
		 */
		public static function buildPatientXRefListFromXML(nodeList:XMLList): ArrayCollection
		{
			var patientXRefList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var patientXRefVO: PatientXRefVO = buildPatientXRefVOFromXML(item);
				patientXRefList.addItem(patientXRefVO);
			}
			return patientXRefList;
		}          
		
		
		private static function buildPatientXRefVOFromXML(xml:XML): PatientXRefVO
		{
			var patientXRefVO: PatientXRefVO = new PatientXRefVO();
			patientXRefVO.id = xml.@id;
			patientXRefVO.patientDfn = xml.@patientDfn;
			patientXRefVO.patientId = xml.@patientId;
			return patientXRefVO;
		}             
		
		/**
		 * creates an array for report categories from XML list
		 * @param nodeList XML nole list
		 * @return 
		 * 
		 */
		public static function buildShiftReportCategoriesFromXML(nodeList:XMLList): ArrayCollection
		{
			var shiftCategoriesList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var shiftCategoryVO: ShiftCategoryVO = buildShiftReportCategoryFromXML(item);
				shiftCategoriesList.addItem(shiftCategoryVO);
			}
			return shiftCategoriesList;
		}            	
		
		
		private static function buildShiftReportCategoryFromXML(xml:XML): ShiftCategoryVO
		{
			var shiftCategoryVO: ShiftCategoryVO = new ShiftCategoryVO();
			shiftCategoryVO.category = xml.@category;
			shiftCategoryVO.one = xml.@one;
			shiftCategoryVO.two = xml.@two;
			shiftCategoryVO.three = xml.@three;
			shiftCategoryVO.four = xml.@four;
			return shiftCategoryVO;
		}            	
		
		/**
		 * creates an array for report columns from XML list 
		 * @param nodeList
		 * @return 
		 * 
		 */
		public static function buildShiftReportColumnsFromXML(nodeList:XMLList): ArrayCollection
		{
			var shiftReportColumnsList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var shiftReportColumnVO: ShiftReportColumnVO = buildShiftReportColumnFromXML(item);
				shiftReportColumnsList.addItem(shiftReportColumnVO);
			}
			return shiftReportColumnsList;
		}              	
		
		private static function buildShiftReportColumnFromXML(xml:XML): ShiftReportColumnVO
		{
			var shiftReportColumnVO: ShiftReportColumnVO = new ShiftReportColumnVO();
			shiftReportColumnVO.name = xml.@name;
			shiftReportColumnVO.shiftId = xml.@shiftId;
			return shiftReportColumnVO;
		}            
		
		/**
		 * creates an array for report stats from XML list 
		 * @param nodeList
		 * @return 
		 * 
		 */
		public static function buildAcuityReportStatsFromXML(nodeList:XMLList): ArrayCollection
		{
			var acuityStatsList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var acuityVO: AcuityVO = buildAcuityStatFromXML(item);
				acuityStatsList.addItem(acuityVO);
			}
			return acuityStatsList;
		}
		
		/**
		 * creates delay chart from XML list 
		 * @param nodeList
		 * @return 
		 * 
		 */
		public static function buildSummaryDelayChartFromXML(nodeList:XMLList): ArrayCollection
		{
			return buildAcuityReportStatsFromXML(nodeList);
		}
		
		private static function buildAcuityStatFromXML(xml:XML): AcuityVO
		{
			var acuityVO: AcuityVO = new AcuityVO();
			acuityVO.none = xml.@none;
			acuityVO.one = xml.@one;
			acuityVO.two = xml.@two;
			acuityVO.three = xml.@three;
			acuityVO.four= xml.@four;
			acuityVO.five = xml.@five;
			acuityVO.type = xml.@type;
			acuityVO.avgTotal = xml.@total;
			acuityVO.reason = xml.@reason;
			return acuityVO;
		}        
		
		/**
		 * creates an array provider list from XML list 
		 * @param nodeList
		 * @return 
		 * 
		 */
		public static function buildProviderListFromXML(nodeList:XMLList): ArrayCollection
		{
			var providerList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var providerVO: ProviderVO = buildProviderVOFromXML(item);
				providerList.addItem(providerVO);
			}
			return providerList;
		}
		
		private static function buildProviderVOFromXML(xml:XML): ProviderVO
		{
			var providerVO: ProviderVO = new ProviderVO();
			providerVO.name = xml.@name;
			providerVO.total = xml.@total;
			providerVO.avgTimeMDAssigned = xml.@timeMD;
			providerVO.avgTimeToDisposition = xml.@timeDisp;
			providerVO.shifts = buildProviderShiftsFromXML(xml.shifts.shift);
			return providerVO;
		}         
		
		private static function buildProviderShiftsFromXML(nodeList:XMLList): ArrayCollection
		{
			var providerShiftList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var providerShiftVO: ProviderShiftVO = buildProviderShiftVOFromXML(item);
				providerShiftList.addItem(providerShiftVO);
			}
			return providerShiftList;
		}
		
		private static function buildProviderShiftVOFromXML(xml:XML): ProviderShiftVO
		{
			var providerShiftVO: ProviderShiftVO = new ProviderShiftVO();
			providerShiftVO.number = xml.@number;
			providerShiftVO.acuity = xml.@acuity;
			providerShiftVO.total = xml.@total;
			providerShiftVO.timeInToMDAssigned = xml.@timeMD;
			providerShiftVO.timeFromMDAssignedToDisposition = xml.@timeDisp;
			return providerShiftVO;
		}  
		
		/**
		 * creates an array Patient exposure list  from XML list 
		 * @param nodeList
		 * @return 
		 * 
		 */
		public static function buildPatientExposureVOListFromXML(nodeList:XMLList): ArrayCollection
		{
			var patientExposureVOList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var patientExposureVO: PatientExposureVO = buildPatientExposureVOFromXML(item);
				patientExposureVOList.addItem(patientExposureVO);
			}
			return patientExposureVOList;
		}
		
		private static function buildPatientExposureVOFromXML(xml:XML): PatientExposureVO
		{
			var patientExposureVO: PatientExposureVO = new PatientExposureVO();
			patientExposureVO.id = xml.@id;
			patientExposureVO.arrival = xml.@arrival;
			patientExposureVO.roomName = xml.@roomName;
			patientExposureVO.disposition = xml.@disposition;
			patientExposureVO.dx = xml.@dx;
			patientExposureVO.shiftIn = xml.@shiftIn;
			patientExposureVO.timeIn = Vista.FMtoDate(xml.@inTS);
			patientExposureVO.shiftOut = xml.@shiftOut;
			patientExposureVO.timeOut = Vista.FMtoDate(xml.@outTS);
			patientExposureVO.notes = xml.@notes;
			return patientExposureVO;
		}       
		/**
		 * creates an array Ed staff list  from XML list 
		 * @param nodeList
		 * @return 
		 * 
		 */
		
		public static function buildEDStaffVOListFromXML(nodeList:XMLList): ArrayCollection
		{
			var edStaffVOList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var edStaffVO: EdStaffVO = buildEDStaffVOFromXML(item);
				edStaffVOList.addItem(edStaffVO);
			}
			return edStaffVOList;
		}
		
		private static function buildEDStaffVOFromXML(xml:XML): EdStaffVO
		{
			var edStaffVO: EdStaffVO = new EdStaffVO();
			edStaffVO.name = xml.@name;
			return edStaffVO;
		} 
		
		/**
		 * creates an array Log entries  from XML list 
		 * @param nodeList
		 * @return 
		 * 
		 */
		public static function buildReportLogEntriesFromXML(nodeList:XMLList): ArrayCollection
		{
			var activityLogEntryList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var reportLogEntryVO: ReportLogEntryVO = buildReportLogEntryFromXML(item);
				activityLogEntryList.addItem(reportLogEntryVO);
			}
			return activityLogEntryList;
		}
		
		private static function buildReportLogEntryFromXML(xml:XML): ReportLogEntryVO
		{
			var reportLogEntryVO: ReportLogEntryVO = new ReportLogEntryVO();
			reportLogEntryVO.id = xml.@id;
			reportLogEntryVO.patientNm = xml.@patientName;
			reportLogEntryVO.acuity = xml.@acuity;
			reportLogEntryVO.complaint = xml.@complaint;
			reportLogEntryVO.disposition = xml.@disposition;
			//TODO; talk to Mel to see how multiple diagnoses as passed on in xml..
			var dx: ArrayCollection = new ArrayCollection();
			dx.addItem(xml.@dx);
			reportLogEntryVO.diagnoses = dx;
			reportLogEntryVO.elapsed = xml.@elapsed;
			reportLogEntryVO.timeIn = Vista.FMtoDate(xml.@inTS);
			reportLogEntryVO.timeOut = Vista.FMtoDate(xml.@outTS);
			reportLogEntryVO.provider = xml.@md;
			reportLogEntryVO.triage = xml.@triage;
			reportLogEntryVO.wait = xml.@wait;
			reportLogEntryVO.admDec = xml.@admDec;
			reportLogEntryVO.admDel = xml.@admDel;
			reportLogEntryVO.arrival = xml.@arrival;
			reportLogEntryVO.icd9 = xml.@icd;
			reportLogEntryVO.delayReason = xml.@delayReason;
			reportLogEntryVO.observation = xml.@observationReason + " ("+xml.@observationTime+")";
			return reportLogEntryVO;
		}       
		
		//buildOrdersByAcuityReportFromXML
		/**
		 * creates an array Acuity Report list  from XML list 
		 * @param nodeList
		 * @return 
		 * 
		 */
		public static function buildOrdersByAcuityLogEntriesFromXML(nodeList:XMLList): ArrayCollection
		{
			var ordersByAcuityLogEntryList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var ordersByAcuityVO: OrdersByAcuityVO = buildOrdersByAcuityLogEntryFromXML(item);
				ordersByAcuityLogEntryList.addItem(ordersByAcuityVO);
			}
			return ordersByAcuityLogEntryList;
		}
		
		//  Changed labs to labs_ordered and labs_reported  -  J Lemaire 9/24/11
		/**
		 * Create the list of acuities ordered
		 * @param xml The xml returned from the VistA call
		 * @returns the orders Value Object
		 */
		private static function buildOrdersByAcuityLogEntryFromXML(xml:XML): OrdersByAcuityVO
		{
			var ordersByAcuityVO: OrdersByAcuityVO = new OrdersByAcuityVO();
			ordersByAcuityVO.acuity = xml.@acuity;
			ordersByAcuityVO.meds = xml.@meds;
			ordersByAcuityVO.labs = xml.@labs;
			ordersByAcuityVO.images = xml.@images;
			ordersByAcuityVO.consults = xml.@consults;
			ordersByAcuityVO.others = xml.@other;
			
			return ordersByAcuityVO;
		}          
		
		
		//buildPtDemographics  --  J Lemaire  9/24/11
		/**
		 * Creates the list of patient's Demography data
		 * @param nodeList Pull the information returned from the VistA call
		 * @returns the array of returned results
		 */
		public static function buildDemographicsFromXML(nodeList:XMLList): ArrayCollection
		{
			var demogEntryList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var demog: PtDemographicsVO = buildDemographics(item);
				demogEntryList.addItem(demog);
			}
			return demogEntryList;
		}
		
		/**
		 * Parse the demographics XML and populate the VO
		 * @param the xml item returned from VistA call
		 * @returns the Demographics value object
		 */
		private static function buildDemographics(xml:XML): PtDemographicsVO
		{
			var demog: PtDemographicsVO = new PtDemographicsVO();
			
			demog.phone = xml.@phone;
			demog.cell = xml.@cell;
			demog.nokPhone = xml.@nokPhone;
			
			return demog;
		}         
		
		/**
		 * Creates the list of patients removed in error data.
		 * @param nodeList Pull the information returned from the VistA call
		 * @returns the array of returned results
		 */
		public static function buildPatientsRemovedInErrorFromXML(nodeList:XMLList): ArrayCollection
		{
			var patientsRemovedInErrorEntryList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var patientRemovedInError:PatientRemovedInErrorVO = buildPatientRemovedInError(item);
				patientsRemovedInErrorEntryList.addItem(patientRemovedInError);
			}
			return patientsRemovedInErrorEntryList;
		}
		
		/**
		 * Parse the patients removed in error XML and populate the VO
		 * @param the xml item returned from VistA call
		 * @returns the prie value object
		 */
		private static function buildPatientRemovedInError(xml:XML): PatientRemovedInErrorVO
		{
			var patientRemovedInError:PatientRemovedInErrorVO = new PatientRemovedInErrorVO();
			
			patientRemovedInError.patientName = xml.@patientName;
			patientRemovedInError.ssn = xml.@ssn;
			patientRemovedInError.timeInED = Vista.FMtoDate(xml.@timeInED);
			patientRemovedInError.timeOutED = Vista.FMtoDate(xml.@timeOutED);
			//patientRemovedInError.restored = xml.@restored;
			patientRemovedInError.restoredBy = xml.@restoredBy;
			patientRemovedInError.restoredDateTime = Vista.FMtoDate(xml.@restoredDateTime);
			patientRemovedInError.closedBy = xml.@closedBy;
			patientRemovedInError.closedDateTime = Vista.FMtoDate(xml.@closedDateTime);
			
			return patientRemovedInError;
		}  
		
		/**
		 * Creates the list of adhoc data.
		 * @param nodeList Pull the information returned from the VistA call
		 * @returns the array of returned results
		 */
		public static function buildCustomReportXML(nodeList:XMLList): ArrayCollection
		{
			var customReportEntryList: ArrayCollection = new ArrayCollection();
			
			for each (var item:XML in nodeList) {
				var customReport:CustomReportVO = buildCustomReport(item);
				customReportEntryList.addItem(customReport);
			}
			return customReportEntryList;
		}

		/**
		 * Creates the list of adhoc data.
		 * @param nodeList Pull the information returned from the VistA call
		 * @returns the array of returned results
		 */
		public static function buildAdhocReportHeaders(nodeList:XMLList): ArrayCollection
		{
			var customReportHeaders: ArrayCollection = new ArrayCollection();
			
			for each(var header:String in nodeList[0]..@header) {
				customReportHeaders.addItem(header);
			}
			
			return customReportHeaders;
		}
		
		private static function buildCustomReport(xml:XML): CustomReportVO
		{
			var customReport: CustomReportVO = new CustomReportVO();
			
			customReport.md = xml.@md;
			customReport.status = xml.@status;
			customReport.elapsedTime= xml.@elapsedTime;
			customReport.complaint= xml.@complaint;
			customReport.admDelay= xml.@admDelay;
			customReport.mDs= xml.@mDs;
			customReport.triageRn= xml.@triageRn;
			customReport.staffRns= xml.@staffRns;
			customReport.acuity= xml.@acuity;
			customReport.wait= xml.@wait;
			customReport.doorToDoc= xml.@doorToDoc;
			customReport.adminDec= xml.@adminDec;
			customReport.rNs= xml.@rNs;
			customReport.dcDx= xml.@dcDx;
			customReport.diagCode= xml.@diagCode;
			customReport.source= xml.@source;
			customReport.ptIdentifier= xml.@ptIdentifier;
			customReport.resident= xml.@resident;
			//customReport.elapsedTime= xml.@elapsedTime;		
			customReport.patientName = xml.@patientName;
			customReport.ssn = xml.@ssn;
			customReport.timeInED = Vista.FMtoDate(xml.@timeInED);
			customReport.timeOutED = Vista.FMtoDate(xml.@timeOutED);
			customReport.restoredBy = xml.@restoredBy;
			customReport.restoredDateTime = Vista.FMtoDate(xml.@restoredDateTime);
			customReport.closedBy = xml.@closedBy;
			customReport.closedDateTime = Vista.FMtoDate(xml.@closedDateTime);
			
			return customReport;
		}  
		/**
		 * creates an array Log list  from XML list 
		 * @param nodeList
		 * @return 
		 * 
		 */
		public static function buildBVACLogEntriesFromXML(nodeList:XMLList): ArrayCollection
		{
			var bvacLogEntryList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var bvacLogEntryVO: BVACLogEntryVO = buildBVACLogEntryFromXML(item);
				bvacLogEntryList.addItem(bvacLogEntryVO);
			}
			return bvacLogEntryList;
		}
		
		private static function buildBVACLogEntryFromXML(xml:XML): BVACLogEntryVO
		{
			var bvacLogEntryVO: BVACLogEntryVO = new BVACLogEntryVO();
			bvacLogEntryVO.id = xml.@id;
			bvacLogEntryVO.acuity = xml.@acuity;
			bvacLogEntryVO.complaint = xml.@complaint;
			bvacLogEntryVO.disposition = xml.@disposition;
			//TODO; talk to Mel to see how multiple diagnoses as passed on in xml..
			var dx: ArrayCollection = new ArrayCollection();
			dx.addItem(xml.@dx);
			bvacLogEntryVO.diagnoses = dx;
			bvacLogEntryVO.elapsed = xml.@elapsed;
			bvacLogEntryVO.timeIn = Vista.FMtoDate(xml.@inTS);
			bvacLogEntryVO.timeOut = Vista.FMtoDate(xml.@outTS);
			bvacLogEntryVO.provider = xml.@md;
			bvacLogEntryVO.triage = xml.@triage;
			bvacLogEntryVO.wait = xml.@wait;
			bvacLogEntryVO.admDec = xml.@admDec;
			bvacLogEntryVO.admDel = xml.@admDel;
			bvacLogEntryVO.arrival = xml.@arrival;
			bvacLogEntryVO.icd9 = xml.@icd;
			bvacLogEntryVO.delayReason = xml.@delayReason;
			
			bvacLogEntryVO.agentOrange = xml.@agentOrange;
			bvacLogEntryVO.iraq = xml.@iraq;
			bvacLogEntryVO.patientName = xml.@patient;
			bvacLogEntryVO.persGulf = xml.@persGulf;
			bvacLogEntryVO.pow = xml.@pow;
			bvacLogEntryVO.purpleHeart = xml.@purpleHeart;
			bvacLogEntryVO.serviceConnPct = xml.@servConnPct;
			bvacLogEntryVO.unemployable = xml.@unemployable;
			bvacLogEntryVO.vaPension = xml.@vaPension;
			bvacLogEntryVO.vietnamVet = xml.@vietnam;
			bvacLogEntryVO.combatEndDate = Vista.FMtoDate(xml.@combatEndDT);
			return bvacLogEntryVO;
		}          
		
		
		
		/**
		 * creates an array Intake list  from XML list 
		 * @param nodeList
		 * @return 
		 * 
		 */
		public static function buildPtIntakeListFromXML(nodeList:XMLList): ArrayCollection
		{
			var ptIntakeList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var ptIntakeVO: PtIntakeVO = buildPtIntakeVOFromXML(item);
				ptIntakeList.addItem(ptIntakeVO);
			}
			return ptIntakeList;
		}      
		
		private static function buildPtIntakeVOFromXML(xml:XML): PtIntakeVO
		{
			var ptIntakeVO: PtIntakeVO = new PtIntakeVO();
			ptIntakeVO.sun = xml.@Sunday;
			ptIntakeVO.mon = xml.@Monday;
			ptIntakeVO.tue = xml.@Tuesday;
			ptIntakeVO.wed = xml.@Wednesday;
			ptIntakeVO.thu = xml.@Thursday;
			ptIntakeVO.fri = xml.@Friday;
			ptIntakeVO.sat = xml.@Saturday;
			ptIntakeVO.time = xml.@time;
			ptIntakeVO.total = xml.@total;
			ptIntakeVO.average = xml.@average;
			
			return ptIntakeVO;
		} 
		
		/**
		 * creates an array of visit averege list  from XML list 
		 * @param nodeList
		 * @return 
		 * 
		 */
		public static function buildReportAveragesFromXML(nodeList:XMLList): ArrayCollection
		{
			var averagesList: ArrayCollection = new ArrayCollection();
			for each (var item:XML in nodeList) {
				var averagesVO: AveragesVO = buildReportAverageFromXML(item);
				averagesList.addItem(averagesVO);
			}
			return averagesList;
		}
		
		private static function buildReportAverageFromXML(xml:XML): AveragesVO
		{
			var averagesVO: AveragesVO = new AveragesVO();
			averagesVO.admDec = xml.@admDec;
			averagesVO.admDel = xml.@admDel;
			averagesVO.elapsed = xml.@elapsed;
			averagesVO.total = xml.@total;
			//Talk to Mel change for attribute to type instead..
			averagesVO.type = xml.@type;
			averagesVO.triage = xml.@triage;
			averagesVO.wait = xml.@wait;
			return averagesVO;
		}
		
		/*XML for getReportList (without elements included)
		
		
		
		^TMP("EDPGLOB",11244,1)="<reports>"
		2)="<report id=""1"" inactive=""false"" name=""TEST TEMPLAT
		E"">"
		3)="<roles roleAbbreviation=""P"" roleID=""1"" roleName=""P
		rovider""/>"
		4)="<roles roleAbbreviation=""R"" roleID=""2"" roleName=""R
		esident""/>"
		5)="</report>"
		6)="</reports>"
		
		
		
		XML for getReportList (with the elements included)
		
		
		
		^TMP("EDPGLOB",11244,1)="<reports>"
		2)="<report id=""1"" inactive=""false"" name=""TEST TEMPLAT
		E"">"
		3)="<elements id=""1"" name=""TEST ELEMENT"" sequence=""1""
		/>"
		4)="<roles roleAbbreviation=""P"" roleID=""1"" roleName=""P
		rovider""/>"
		5)="<roles roleAbbreviation=""R"" roleID=""2"" roleName=""R
		esident""/>"
		6)="</report>"
		7)="</reports>"*/
		
		/** 
		 * Build the adhoc report list  list from xml data.
		 * 
		 * @param nodeList XML nodelist to build. 
		 * 
		 * @return ArrayCollection of built objects. 
		 */ 		
		public static function buildAdhocReportListFromXML(nodeList: XMLList): ArrayCollection
		{		
			var adhocReportListVOList:ArrayCollection = new ArrayCollection();
			
			for each (var item: XML in nodeList) {
				
				var adhocReportListVO:AdhocReportVO = new AdhocReportVO();				
				adhocReportListVO = buildAdhocReportItemFromXML(item);
				//Alert.show("WSF.buildAdhocReportListFromXML add -> " + workSheetListVO.toString());
				adhocReportListVOList.addItem(adhocReportListVO);
				
			}
			
			return adhocReportListVOList;
		}
		
		/** 
		 * Build a adhoc report list item from xml data.
		 * @param xml XML data to build. 
		 * 
		 * @return AdhocReportListVO object. 
		 */ 	
		public static function buildAdhocReportItemFromXML(xml:XML):AdhocReportVO
		{
			var adhocReportListVO:AdhocReportVO = new AdhocReportVO();					
			adhocReportListVO.id = xml.@id;
			adhocReportListVO.inactive = xml.@inactive;
			adhocReportListVO.name = xml.@name;
			adhocReportListVO.label = adhocReportListVO.name;
			adhocReportListVO.data = adhocReportListVO.id;
			
			adhocReportListVO.elementsVO = buildAdhocReportElementListFromXML(xml.element);
			
			adhocReportListVO.rolesVO = buildAdhocReportRoleListFromXML(xml.role);
			
			return adhocReportListVO;
		}
		
		
		/** 
		 * Build the adhoc report list from xml data.
		 * 
		 * @param nodeList XML nodelist to build. 
		 * 
		 * @return ArrayCollection of built objects. 
		 */ 		
		public static function buildAdhocReportRoleListFromXML(nodeList: XMLList): ArrayCollection
		{		
			var adhocReportRoleListVOList:ArrayCollection = new ArrayCollection();
			
			for each (var item: XML in nodeList) {
				
				var adhocReportRoleListVO:AdhocReportRoleVO = new AdhocReportRoleVO();				
				adhocReportRoleListVO = buildAdhocReportRoleItemFromXML(item);
				//Alert.show("WSF.buildAdhocReportListFromXML add -> " + workSheetListVO.toString());
				adhocReportRoleListVOList.addItem(adhocReportRoleListVO);
				
			}
			
			return adhocReportRoleListVOList;
		}
		
		/** 
		 * Build a adhoc report list item from xml data.
		 * @param xml XML data to build. 
		 * 
		 * @return AdhocReportListVO object. 
		 */ 	
		public static function buildAdhocReportRoleItemFromXML(xml:XML):AdhocReportRoleVO
		{
			var adhocReportRoleListVO:AdhocReportRoleVO = new AdhocReportRoleVO();					
			adhocReportRoleListVO.roleID = Number(xml.@id);
			adhocReportRoleListVO.roleAbbreviation = xml.@abbreviation;
			adhocReportRoleListVO.roleName = xml.@name;	
			return adhocReportRoleListVO;
		}
		
		/** 
		 * Build the adhoc report element  list from xml data.
		 * 
		 * @param nodeList XML nodelist to build. 
		 * 
		 * @return ArrayCollection of built objects. 
		 */ 		
		public static function buildAdhocReportElementListFromXML(nodeList: XMLList): ArrayCollection
		{		
			var adhocReportElementListVOList:ArrayCollection = new ArrayCollection();
			
			for each (var item: XML in nodeList) {
				
				var adhocReportElementListVO:AdhocReportElementVO = new AdhocReportElementVO();				
				adhocReportElementListVO = buildAdhocReportElementItemFromXML(item);
				//Alert.show("WSF.buildAdhocReportListFromXML add -> " + workSheetListVO.toString());
				adhocReportElementListVOList.addItem(adhocReportElementListVO);
				
			}
			
			return adhocReportElementListVOList;
		}
		
		/** 
		 * Build a adhoc report element item from xml data.
		 * @param xml XML data to build. 
		 * 
		 * @return AdhocReportElementVO object. 
		 */ 	
		public static function buildAdhocReportElementItemFromXML(xml:XML):AdhocReportElementVO
		{
			var adhocReportElementListVO:AdhocReportElementVO = new AdhocReportElementVO();					
			adhocReportElementListVO.id = Number(xml.@id);
			adhocReportElementListVO.sequence = Number(xml.@sequence);
			adhocReportElementListVO.name = xml.@name;	
			return adhocReportElementListVO;
		}
		
	}
	
}