/* DebugFactory.as */

package gov.va.med.edp.factory
{
    import gov.va.med.edp.business.CSPService;
    import gov.va.med.edp.model.TrackingModelLocator;
    import gov.va.med.edp.vo.DebugVO;
    
    import mx.collections.ArrayCollection;
    import mx.utils.ObjectUtil;
        
	/** 
	 * Factory for generating debug related objects.
	 */
    public class DebugFactory
    {

		 
		/**
		 * update debug related objects.
		 * @param cspService type CSPService
		 * @param results type debugVO
		 * @param fault optional
		 * @param parameters
		 * 
		 */
    	public static function updateDebugModel(cspService:CSPService, results:String, fault:String, parameters:Object): void
        {
			var model:TrackingModelLocator = TrackingModelLocator.getInstance();
			var list:ArrayCollection = model.debug.cspServiceCallList;
			
			if (list != null){
				var debugVO: DebugVO= new DebugVO()
				debugVO.url = cspService.url;
				debugVO.command = cspService.command;
	
				debugVO.parameters = ObjectUtil.toString(parameters);
				debugVO.request = ObjectUtil.toString(cspService);
				
				debugVO.results = results;
				if (fault != "" && fault != null){
					debugVO.results = fault;
				}
				list.addItem(debugVO);			
			}
        }
        
    }
    
}