package gov.va.med.edp.cpe.widget
{
	import flash.events.Event;
	import flash.events.FocusEvent;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
	
	import gov.va.med.edp.control.DisplayBoardEvent;
	import gov.va.med.edp.control.TrackingEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.ChangeWatcher;
	
	import mx.binding.utils.BindingUtils;
	import mx.controls.Alert;
	import mx.controls.TextInput;
	import mx.controls.listClasses.BaseListData;
	import mx.events.FlexEvent;
	import mx.events.FlexMouseEvent;
	/**
	 *  
	 * Textfield providing a way to capture input.
	 * 
	 */	
	public class TextField extends TextInput
	{
		
		[Bindable]
		/**
		 * Reference to the model.  
		 */
		public var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		private static var tooltipMessage:String = "Press the 'Enter' key to save changes.";
		
		/**
		 * Constructor for the TextField 
		 */
		public function TextField()
		{
			super();
			
			this.addEventListener( KeyboardEvent.KEY_DOWN, getKeyEvent );
			
			this.height = 20;
			
			if(isDisplayBoardView()) {
				disable();
			} else {
				enable();
			}			
		}
		
		private function enable():void
		{
			this.editable = true;
			this.toolTip = tooltipMessage;
		}
		
		private function disable():void
		{
			this.editable = false;
			this.toolTip = null;
		}

		private function reportKey(event:KeyboardEvent):void {
			trace(String.fromCharCode(event.charCode) + "   (" + event.charCode+")");
		}
		
		private function onFocusOut(event:Event):void
		{
			if(!isDisplayBoardView()) { 
				enable();
			}
		}

		private function getKeyEvent(event:KeyboardEvent):void {
			if(!isDisplayBoardView()) { 
				enable();	
				if (event.charCode == Keyboard.ENTER) {
					onChange(event);
				}
			} 
			else {
				disable();
			}
		}
		private function onChange( event:Event ):void {
			if(!isDisplayBoardView()) {
				enable();								
				ChangeWatcher.changeField(event);			
				var e: TrackingEvent = new TrackingEvent(TrackingEvent.EVENT_SAVE_AND_REFRESH_DISPLAYBOARD);
				e.dispatch();			
			} else {
				disable();
			}
		}
		
		private function isDisplayBoardView():Boolean {
			return (model.logEntryViewState == TrackingModelLocator.VIEW_EDIT_DISPLAY_BOARD);
		}
			
	} 
}
