package gov.va.med.edp.cpe.widget
{
	import gov.va.med.edp.control.TrackingEvent;
	import gov.va.med.edp.util.ChangeWatcher;
	
	import mx.collections.IViewCursor;
	import mx.controls.Alert;
	import mx.controls.ComboBox;
	import mx.controls.listClasses.BaseListData;
	import mx.events.ListEvent;
	
	/**
	 * Customize the flex combobox.
	 * 
	 *
	 */	
	public class SelectableComboBox extends ComboBox implements mx.controls.listClasses.IDropInListItemRenderer
	{
		private var savedSelectedIndex:int;

		public function SelectableComboBox()
		{
			super();
			this.addEventListener( ListEvent.CHANGE, onChange );
			this.rowCount = 12;
			this.setStyle("arrowButtonWidth",30);
		}
		
		// Internal variable for the property value.
		private var _listData: BaseListData;
		
		[Bindable("dataChange")]
		// Make the listData property bindable.
		override public function get listData():BaseListData {
			return _listData;
		}
		override public function set listData(value:BaseListData):void {
			_listData = value;
		}
		
		override public function set data(value:Object):void
		{
			super.data = value;
			var item:Object;
			Alert.show("data input value = "+value);
			trace("********** value = "+value);
			item = value[listData["dataField"]] ? value[listData["dataField"]] : value.label;
			trace(">>>>> "+listData["dataField"]);
			this.selectedItemSet(item);
		}
		
		private function selectedItemSet(value:Object):void
		{
			super.selectedItem = value;
			if (value != null && selectedIndex == -1)
			{
				// do a painful search;
				if (collection && collection.length)
				{
					var cursor:IViewCursor = collection.createCursor();
					while (!cursor.afterLast)
					{
						var obj:Object = cursor.current;
						var nope:Boolean = false;
						for (var p:String in value)
						{
							trace(obj.label+" - "+p+" - "+value[p]);
							if (obj.label != value[p])
							{
								nope = true;
								break;
							}
						}
						if (!nope)
						{
							super.selectedItem = obj;
							return;
						}
						cursor.moveNext();
					}
				}
			}
		}
		
		private function onChange( event:ListEvent ):void {
			savedSelectedIndex = this.selectedIndex;
			ChangeWatcher.changeField(event);
			
			// JNL -- save log entry after every edit
			//var e: TrackingEvent = new TrackingEvent(TrackingEvent.EVENT_SAVE_LOG_ENTRY);
			var e: TrackingEvent = new TrackingEvent(TrackingEvent.EVENT_SAVE_AND_REFRESH_DISPLAYBOARD);
			e.dispatch();
		}
		

	} 
}
