package gov.va.med.edp.cpe.widget {
import flash.events.Event;

import mx.core.FlexVersion;
import mx.core.IDataRenderer;
import mx.core.IDeferredInstance;
import mx.core.IUIComponent;
import mx.core.mx_internal;
import mx.styles.ISimpleStyleClient;

use namespace mx_internal;

/**
 * Manage the link popup behavior.
 * 
 *
 */	
[Style(name="popUpStyleName", type="String", inherit="no")]
[Event(name="infoClick", type="gov.va.med.edp.widget.InfoButtonClickEvent")]
public class LinkButtonPopUp extends LinkButton {

    private var showingPopUp:Boolean = false;

    public function LinkButtonPopUp() {
		setStyle("popUpStyleName", "infoButtonPopUp");
        addEventListener(InfoButtonClickEvent.EVENT_INFO_CLICK, infoClickHandler);
    }

    private function infoClickHandler(e:InfoButtonClickEvent):void {
        if (popUp != null) {
            var popUpInstance:Object = popUp.getInstance();
            if (popUpInstance is IDataRenderer) {
                (popUpInstance as IDataRenderer).data = e.item;
            }
            if (FlexVersion.compatibilityVersion >= FlexVersion.VERSION_3_0 && popUpInstance is ISimpleStyleClient) {
				ISimpleStyleClient(popUpInstance).styleName = getStyle("popUpStyleName");
			}

            InfoButtonPopUpManager.show(popUpInstance as IUIComponent, this, e.infoButtonBounds);
        }
    }

    private var _popUp:IDeferredInstance;

	[InstanceType("mx.core.IUIComponent")]
    [Bindable(event="popUpChanged")]
    public function get popUp():IDeferredInstance {
        return _popUp;
    }

    public function set popUp(value:IDeferredInstance):void {
        _popUp = value;

//        if (this) {
//            this.invalidateDisplayList();
//        }

        dispatchEvent(new Event("popUpChanged"));
    }

    //----------------------------------
    //  stylesFunction
    //----------------------------------

    private var _stylesFunction:Function;

    [Bindable(event="stylesFunctionChanged")]
    public function get stylesFunction():Function {
        return _stylesFunction;
    }

    public function set stylesFunction(value:Function):void {
        _stylesFunction = value;

        if (this) {
            this.invalidateDisplayList();
        }

        dispatchEvent(new Event("stylesFunctionChanged"));
    }
}
}