package gov.va.med.edp.cpe.widget 
{
import flash.display.DisplayObject;
import flash.events.Event;
import flash.events.KeyboardEvent;
import flash.events.MouseEvent;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.ui.Keyboard;
import mx.controls.Menu;
import mx.controls.listClasses.IListItemRenderer;
import mx.core.FlexVersion;
import mx.core.IFlexDisplayObject;
import mx.core.IUIComponent;
import mx.core.UIComponent;
import mx.events.FlexMouseEvent;
//import mx.events.InterManagerRequest;
import mx.events.ListEvent;
import mx.events.MenuEvent;
//import mx.events.SandboxMouseEvent;
import mx.managers.IFocusManagerComponent;
import mx.managers.ISystemManager;
import mx.managers.PopUpManager;
import mx.styles.ISimpleStyleClient;
import mx.core.Application;

/**
 * Manage the popup icon buttons.
 * 
 *
 */	
public class InfoButtonPopUpManager {

    private static var showingInfoButtonBounds:Rectangle;
    private static var showingPopUp:IUIComponent;

	/**
	 *Show popup 
	 * @param popUp
	 * @param parent
	 * @param infoButtonBounds
	 * 
	 */
    public static function show(popUp:IUIComponent, parent:UIComponent, infoButtonBounds:Rectangle):void {
        close();

        if (popUp == null || parent == null)
            return;

        PopUpManager.addPopUp(popUp, parent);
        popUp.owner = parent;

        if (popUp is IFocusManagerComponent)
            IFocusManagerComponent(popUp).focusEnabled = false;

        popUp.cacheAsBitmap = true;
        //        popUp.scrollRect = new Rectangle(0, 0, 0, 0);

        if (popUp is IListItemRenderer) {
            popUp.addEventListener(
                    ListEvent.ITEM_CLICK, popUpItemClickHandler);
        }

        popUp.addEventListener(FlexMouseEvent.MOUSE_DOWN_OUTSIDE,
                popMouseDownOutsideHandler);
        popUp.addEventListener(FlexMouseEvent.MOUSE_WHEEL_OUTSIDE,
                popMouseDownOutsideHandler);
        /*popUp.addEventListener(SandboxMouseEvent.MOUSE_DOWN_SOMEWHERE,
                popMouseDownOutsideHandler);
        popUp.addEventListener(SandboxMouseEvent.MOUSE_WHEEL_SOMEWHERE,
                popMouseDownOutsideHandler);
		*/
		popUp.addEventListener(MouseEvent.MOUSE_DOWN,
			popMouseDownOutsideHandler);
		popUp.addEventListener(MouseEvent.MOUSE_DOWN,
			popMouseDownOutsideHandler);
        popUp.owner.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);


        var point:Point = new Point(infoButtonBounds.x, infoButtonBounds.y + infoButtonBounds.height);
        point = parent.localToGlobal(point);

        //var sm:ISystemManager = parent.systemManager.topLevelSystemManager;
        //var sbRoot:DisplayObject = sm.getSandboxRoot();
		
        var screen:Rectangle;
		
		screen = Application.application.screen;
		
       // if (sm != sbRoot) {
           // var request:InterManagerRequest = new InterManagerRequest(InterManagerRequest.SYSTEM_MANAGER_REQUEST,
           //         false, false,
           //         "getVisibleApplicationRect");
           // sbRoot.dispatchEvent(request);
			//Application.application.dispatchEvent(request)
           // screen = Rectangle(request.value);
       // } else {
       //     screen = sm.getVisibleApplicationRect();
       // }

        if (point.y + popUp.height > screen.bottom &&
            point.y > (screen.top + infoButtonBounds.height + popUp.getExplicitOrMeasuredHeight())) {
            // PopUp will go below the bottom of the stage
            // and be clipped. Instead, have it grow up.
            point.y -= (infoButtonBounds.height + popUp.getExplicitOrMeasuredHeight());
        }

        point.x = Math.min(point.x, screen.right - popUp.getExplicitOrMeasuredWidth());
        point.x = Math.max(point.x, 0);
        point = popUp.parent.globalToLocal(point);
        if (popUp.x != point.x || popUp.y != point.y)
            popUp.move(point.x, point.y);

        showingInfoButtonBounds = infoButtonBounds;
        showingPopUp = popUp;
    }

	/**
	 *close poup 
	 * 
	 */
    public static function close():void {
        if (showingPopUp != null) {
            if (showingPopUp is IListItemRenderer) {
                showingPopUp.removeEventListener(
                        ListEvent.ITEM_CLICK, popUpItemClickHandler);
            }

            showingPopUp.removeEventListener(FlexMouseEvent.MOUSE_DOWN_OUTSIDE,
                    popMouseDownOutsideHandler);
            showingPopUp.removeEventListener(FlexMouseEvent.MOUSE_WHEEL_OUTSIDE,
                    popMouseDownOutsideHandler);
            /*showingPopUp.removeEventListener(SandboxMouseEvent.MOUSE_DOWN_SOMEWHERE,
                    popMouseDownOutsideHandler);
            showingPopUp.removeEventListener(SandboxMouseEvent.MOUSE_WHEEL_SOMEWHERE,
                    popMouseDownOutsideHandler);
			*/
			showingPopUp.removeEventListener(MouseEvent.MOUSE_DOWN,
				popMouseDownOutsideHandler);
			showingPopUp.removeEventListener(MouseEvent.MOUSE_DOWN,
				popMouseDownOutsideHandler);
            showingPopUp.owner.removeEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);

            PopUpManager.removePopUp(showingPopUp);
            showingPopUp = null;
            showingInfoButtonBounds = null;
        }
    }

    /**
     *  @private
     *  Close popUp for IListItemRenderer's like List/Menu.
     */
    private static function popUpItemClickHandler(event:Event):void {

        //        if (_closeOnActivity)
        close();
    }

    /**
     *  @private
     */
    private static function popMouseDownOutsideHandler(event:Event):void {
        if (event is MouseEvent) {
            // for automated testing, since we're generating this event and
            // can only set localX and localY, transpose those coordinates
            // and use them for the test point.
            var mouseEvent:MouseEvent = MouseEvent(event);
            var p:Point = event.target.localToGlobal(new Point(mouseEvent.localX,
                    mouseEvent.localY));
            p = showingPopUp.parent.globalToLocal(p);
            if (showingInfoButtonBounds.containsPoint(p)) {
                // NOOP
            } else {
                close();
            }
        //} else if (event is SandboxMouseEvent) {
		} else if (event is MouseEvent) {	
            close();
        }
    }

    private static function keyDownHandler(event:KeyboardEvent):void {
        if ((event.ctrlKey && event.keyCode == Keyboard.UP) ||
            (event.keyCode == Keyboard.ESCAPE)) {
            //            closeWithEvent(event);
            close();
            event.stopPropagation();
        } else if (event.keyCode == Keyboard.ENTER && showingPopUp != null) {
            // Redispatch the event to the popup
            // and let its keyDownHandler() handle it.
            showingPopUp.dispatchEvent(event);
            close();
            //                closeWithEvent(event);
            event.stopPropagation();
        } else if (showingPopUp != null &&
                 (event.keyCode == Keyboard.UP ||
                  event.keyCode == Keyboard.DOWN ||
                  event.keyCode == Keyboard.LEFT ||
                  event.keyCode == Keyboard.RIGHT ||
                  event.keyCode == Keyboard.PAGE_UP ||
                  event.keyCode == Keyboard.PAGE_DOWN)) {
                // Redispatch the event to the popup
                // and let its keyDownHandler() handle it.
                showingPopUp.dispatchEvent(event);
                event.stopPropagation();
            }
    }
}
}