package gov.va.med.edp.cpe.widget 
{
import flash.display.DisplayObject;
import flash.events.Event;
import flash.geom.Point;
import flash.geom.Rectangle;
import gov.va.med.edp.cpe.widget.IconLabelInfoButtonCellRenderer;
import mx.containers.TitleWindow;
import mx.controls.Alert;
import mx.controls.dataGridClasses.DataGridColumn;
import mx.core.ClassFactory;
import mx.core.FlexVersion;
import mx.core.IDataRenderer;
import mx.core.IDeferredInstance;
import mx.core.IFlexDisplayObject;
import mx.core.IUIComponent;
import mx.core.mx_internal;
//import mx.events.InterManagerRequest;
import mx.events.ItemClickEvent;
import mx.managers.ISystemManager;
import mx.managers.PopUpManager;
import mx.styles.ISimpleStyleClient;

use namespace mx_internal;

/**
 * Renderer for a datagrid column
 */
[Style(name="popUpStyleName", type="String", inherit="no")]
[Event(name="infoClick", type="gov.va.med.edp.cpe.widget.InfoButtonClickEvent")]
public class IconLabelInfoButtonColumn extends DataGridColumn {

    private var showingPopUp:Boolean = false;

	/**
	 * Lable button config
	 * @param columnName
	 * 
	 */
    public function IconLabelInfoButtonColumn(columnName:String = null) {
		super(columnName);
		setStyle("popUpStyleName", "infoButtonPopUp");
        itemRenderer = new ClassFactory(IconLabelInfoButtonCellRenderer);
        addEventListener(InfoButtonClickEvent.EVENT_INFO_CLICK, infoClickHandler);
    }

    private function infoClickHandler(e:InfoButtonClickEvent):void {
        if (popUp != null) {
            var popUpInstance:Object = popUp.getInstance();
            if (popUpInstance is IDataRenderer) {
                (popUpInstance as IDataRenderer).data = e.item;
            }
            if (FlexVersion.compatibilityVersion >= FlexVersion.VERSION_3_0 && popUpInstance is ISimpleStyleClient) {
				ISimpleStyleClient(popUpInstance).styleName = getStyle("popUpStyleName");
			}

//            InfoButtonPopUpManager.show(popUpInstance as IUIComponent, this.owner, e.infoButtonBounds);
        }
    }

    private var _popUp:IDeferredInstance;

	[InstanceType("mx.core.IUIComponent")]
    [Bindable(event="popUpChanged")]
    public function get popUp():IDeferredInstance {
        return _popUp;
    }

	/**
	 * popup function 
	 * @param value
	 * 
	 */
    public function set popUp(value:IDeferredInstance):void {
        _popUp = value;

        if (owner) {
            owner.invalidateList();
        }

        dispatchEvent(new Event("popUpChanged"));
    }

    //----------------------------------
    //  stylesFunction
    //----------------------------------

    private var _stylesFunction:Function;

    [Bindable(event="stylesFunctionChanged")]
    public function get stylesFunction():Function {
        return _stylesFunction;
    }

	/**
	 * style function 
	 * @param value
	 * 
	 */
    public function set stylesFunction(value:Function):void {
        _stylesFunction = value;

        if (owner) {
            owner.invalidateList();
        }

        dispatchEvent(new Event("stylesFunctionChanged"));
    }

    //----------------------------------
    //  iconField
    //----------------------------------

    /**
     *  @private
     *  Storage for iconField property.
     */
    private var _iconField:String = "icon";

    [Bindable("iconFieldChanged")]
    [Inspectable(category="Data", defaultValue="")]

    /**
     *  The name of the field in the data provider object that determines what to
     *  display as the icon. By default, the list class does not try to display
     *  icons with the text in the rows. However, by specifying an icon
     *  field, you can specify a graphic that is created and displayed as an
     *  icon in the row.  This property is ignored by DataGrid.
     *
     *  <p>The renderers will look in the data provider object for a property of
     *  the name supplied as the iconField.  If the value of the property is a
     *  Class, it will instantiate that class and expect it to be an instance
     *  of an IFlexDisplayObject. If the value of the property is a String,
     *  it will look to see if a Class exists with that name in the application,
     *  and if it can't find one, it will also look for a property on the
     *  document with that name and expect that property to map to a Class.</p>
     *
     *  @default null
     */
    public function get iconField():String
    {
        return _iconField;
    }

    /**
     *  @private
     */
    public function set iconField(value:String):void
    {
        _iconField = value;

        includeIconInLayout = iconFunction != null;

        if (owner) {
            owner.invalidateList();
        }

        dispatchEvent(new Event("iconFieldChanged"));
    }

    //----------------------------------
    //  iconFunction
    //----------------------------------

    /**
     *  @private
     *  Storage for iconFunction property.
     */
    private var _iconFunction:Function;

    [Bindable("iconFunctionChanged")]
    [Inspectable(category="Data")]

    /**
     *  A user-supplied function to run on each item to determine its icon.
     *  By default the list does not try to display icons with the text
     *  in the rows.  However, by specifying an icon function, you can specify
     *  a Class for a graphic that will be created and displayed as an icon
     *  in the row.  This property is ignored by DataGrid.
     *
     *  <p>The iconFunction takes a single argument which is the item
     *  in the data provider and returns a Class.</p>
     *
     *  <blockquote>
     *  <code>iconFunction(item:Object):Class</code>
     *  </blockquote>
     *
     *  @default null
     */
    public function get iconFunction():Function
    {
        return _iconFunction;
    }

    /**
     *  @private
     */
    public function set iconFunction(value:Function):void
    {
        _iconFunction = value;

        includeIconInLayout = iconFunction != null;

        if (owner) {
            owner.invalidateList();
        }

        dispatchEvent(new Event("iconFunctionChanged"));
    }

    private var _includeIconInLayout:Boolean = false;

    [Bindable(event="includeIconInLayouChanged")]
    public function get includeIconInLayout():Boolean {
        return _includeIconInLayout;
    }

    public function set includeIconInLayout(val:Boolean):void {
        _includeIconInLayout = val;

        if (owner) {
            owner.invalidateList();
        }

        dispatchEvent(new Event("includeIconInLayoutChanged"));
    }

    /**
     *  Returns the class for an icon, if any, for a data item,
     *  based on the iconField and iconFunction properties.
     *  The field in the item can return a string as long as that
     *  string represents the name of a class in the application.
     *  The field in the item can also be a string that is the name
     *  of a variable in the document that holds the class for
     *  the icon.
     *
     *  @param data The item from which to extract the icon class.
     *  @return The icon for the item, as a class reference or
     *  <code>null</code> if none.
     */
    public function itemToIcon(data:Object):Class
    {
        if (data == null)
            return null;

        if (iconFunction != null)
            return iconFunction(data);

        var iconClass:Class;
        var icon:*;

        if (data is XML)
        {
            try
            {
                if (data[iconField].length() != 0)
                {
                    icon = String(data[iconField]);
                    if (icon != null)
                    {
                        iconClass =
                        Class(owner.systemManager.getDefinitionByName(icon));
                        if (iconClass)
                            return iconClass;

                        return owner.document[icon];
                    }
                }
            }
            catch(e:Error)
            {
            }
        }

        else if (data is Object)
        {
            try
            {
                if (data[iconField] != null)
                {
                    if (data[iconField] is Class)
                        return data[iconField];

                    if (data[iconField] is String)
                    {
                        iconClass = Class(owner.systemManager.getDefinitionByName(
                                data[iconField]));
                        if (iconClass)
                            return iconClass;

                        return owner.document[data[iconField]];
                    }
                }
            }
            catch(e:Error)
            {
            }
        }

        return null;
    }
}
}