package gov.va.med.edp.cpe.view.vitals {
import gov.va.med.edp.util.Vista;

import gov.va.med.edp.vo.TrackVitalVO;
import gov.va.med.edp.vo.VitalsVO;
import mx.collections.ArrayCollection;

/**
 * Builds and maintains the vitals package data.
 * 
 *
 */	
public class VitalsXml {

	/**
	 * The main call parse vitals and map to VitalsVO
	 * 
	 * @param nodeList type XMLList
	 */
	public static function buildVitals(nodeList: XMLList): ArrayCollection
	{
		var vitalsVO: VitalsVO;
		var vitalArray: ArrayCollection = new ArrayCollection();
		for each (var item: XML in nodeList.vital) {
			vitalsVO = new VitalsVO();
			vitalsVO.bp = item.@BP;
			vitalsVO.error = (item.@error == "true") ? true : false;
			vitalsVO.ht = item.@HT;
			vitalsVO.p = item.@P;
			vitalsVO.pn = item.@PN;
			vitalsVO.r = item.@R;
			vitalsVO.t = item.@T;
			//vitalsVO.time = item.@time;
			vitalsVO.time = Vista.FMtoDateSeconds(item.@time).toString();
			vitalsVO.wt = item.@WT;
			vitalArray.addItem(vitalsVO);
					
		}
		return vitalArray;
	}
	/**
	 * The main call parse vitals and map to TrackVitalVO
	 * 
	 * @param nodeList type XMLList
	 */
	public static function buildTrackVitals(nodeList: XMLList): ArrayCollection
	{
		var trackVitalVO: TrackVitalVO;
		var vitalTemplate: ArrayCollection = new ArrayCollection();
		for each (var item: XML in nodeList.trackVital) {
			trackVitalVO = new TrackVitalVO();
			trackVitalVO.name = item.@name;
			trackVitalVO.symbol = item.@symbl;
			trackVitalVO.track = (item.@track == "true") ? true : false;
			vitalTemplate.addItem(trackVitalVO);
		}
		return vitalTemplate;
	}
}
}