package gov.va.med.edp.cpe.view.vitals
{
	import mx.utils.StringUtil;
	import mx.validators.ValidationResult;
	import mx.validators.Validator;
	
	/**
	 * 
	 * This validator ensures that the format for the blood pressure string is Number/Number. 
	 * @author iainapostolos
	 * 
	 */
	public class BloodPressureValidator extends Validator
	{
		
		private var results:Array;
		
		/**
		 * Constructor for the BloodPressureValidator.
		 */
		public function BloodPressureValidator()
		{
			super();
			
		}	
		
		override protected function doValidation(value:Object):Array {
			
			var inputValue:String = String(value);
			var params:Array = value.split("/", 2);
			var hasSlash:Boolean = true;
			var areNumbers:Boolean = true;
			
			results = [];
			results = super.doValidation(value);
					
			
			if (results.length > 0)
				return results;
			
			if (params.length != 2) {
				results.push(new ValidationResult(true, null, "noSlash", "BP must contain a '/' ."));
				hasSlash = false;
				return results;
			} else {
				
				if ((isNaN(params[0]) || !params[0]) ||  (isNaN(params[1]) || !params[1])) {
					results.push(new ValidationResult(true, null, "noNumbers", "BP must contain Number/Number."));
					return results;
				} else {
					areNumbers = false;
				}
				
			}
			
			return results;
		}
	}
}