package gov.va.med.edp.control.worksheet
{
	import com.adobe.cairngorm.control.CairngormEvent;
	import flash.events.Event;
	
	/**
	 * Status related to worksheet lifecycle. 
	 * @author useruseruser12
	 * 
	 */
	public class WorkSheetStatusEvent extends CairngormEvent
	{
		
		/**
		 * Status related to worksheet lifecyle.
		 */
		public static const INITIALIZED: String = "WORKSHEET_INITIALIZED";
		public static const INITIALIZING: String = "WORKSHEET_INITIALIZING";
		public static const EXECUTING: String = "WORKSHEET_EXECUTING";
		public static const LOADED: String = "WORKSHEET_LOADED";
		public static const LOADING: String = "WORKSHEET_LOADING";
		public static const SAVED: String = "WORKSHEET_SAVED";
		public static const SAVING: String = "WORKSHEET_SAVING";
		public static const RESET: String = "WORKSHEET_RESET";
		public static const ERROR: String = "WORKSHEET_ERROR";
		public static const ADDED: String = "WORKSHEET_ADDED";
		public static const MODEL_ADDED: String = "WORKSHEET_MODEL_ADDED";
		
		/**
		 * Name associated with this worksheet event.
		 */
		public var worksheetName:String;
		
		/**
		 * Constructor.

		 * @param type - Type of status.
		 * @param worksheetName - Name of the worksheet.
		 * @param bubbles - Bubble up.
		 * @param cancelable - Can cancel.
		 * 
		 */
		public function WorkSheetStatusEvent(type:String, worksheetName:String = null, bubbles:Boolean=false, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
			this.worksheetName = worksheetName;
		}
		
		/**
		 * Copy this object.
		 * @return 
		 * 
		 */
		override public function clone():Event
		{
			return new WorkSheetStatusEvent(type,this.worksheetName);
		}
	}
}