package gov.va.med.edp.control.worksheet
{
	import com.adobe.cairngorm.control.CairngormEvent;
	import gov.va.med.edp.control.AbstractNotificationEvent;
	import flash.events.Event;
	import mx.rpc.IResponder;
	/**
	 * Class that loads worksheet related artifacts.
	 * 
	 * @author useruseruser12
	 * 
	 */
	public class LoadWorkSheetEvent extends AbstractNotificationEvent
	{
		
		/**
		 * 
		 */
		public static const EVENT_LOAD_WORKSHEET: String = "loadWorksheet";
		public static const EVENT_LOAD_WORKSHEET_WIDGET: String = "loadWorksheetWidget";
		public static const EVENT_LOAD_WORKSHEET_LIST: String = "loadWorksheetList";
		public static const EVENT_LOAD_WORKSHEET_LIST_VIEW: String = "loadWorksheetListView";
		public static const EVENT_LOAD_REQUIRED_WORKSHEETS: String = "loadRequiredWorksheets";
		public static const EVENT_GET_WORKSHEET: String = "getWorksheet";
		public static const EVENT_GET_WORKSHEET_VIEW: String = "getWorksheetView";
		public static const EVENT_GET_WORKSHEET_SEQUENCE: String = "getWorksheetSequence";
		public static const EVENT_GET_SECTION_LIST: String = "getSectionList";
		public static const EVENT_GET_COMPONENT_LIST: String = "getComponentList";
		public static const EVENT_GET_ARTIFACTS: String = "getArtifacts";
		public static const EVENT_SWITCH_WORKSHEET: String = "switchWorksheet";
		

		public var role:String;
		public var worksheetID:String;
		public var worksheetName:String;
		public var componentID:String;
		
		/**
		 * Loads worksheets.
		 * 
		 * @param type the ReportListEvent variable
		 * @param callbacks callback function to call upon succesful completion
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 * 
		 */
		public function LoadWorkSheetEvent(type:String, callbacks:IResponder=null, bubbles:Boolean=false, cancelable:Boolean=false)
		{
			super(type, callbacks, bubbles, cancelable);
			this.callbacks=callbacks;
		}
		
		/**
		 * 
		 * @return 
		 * 
		 */
		override public function clone():Event
		{
			return new LoadWorkSheetEvent(type, this.callbacks);
		}
	}
}