package gov.va.med.edp.control.reports.adhoc
{
	import com.adobe.cairngorm.control.CairngormEvent;
	import gov.va.med.edp.control.AbstractNotificationEvent;
	import flash.events.Event;
	import mx.rpc.IResponder;
	import mx.collections.ArrayCollection;
	
	/**
	 * Event to save or delete a ad hoc report.
	 * 
	 * @author useruseruser12
	 * 
	 */
	public class ReportSaveEvent extends AbstractNotificationEvent
	{	
		/**
		 * Event to open a  report.
		 */
		public static const EVENT_OPEN_ADHOC_REPORT: String = "OPEN";
		/**
		 * Event to inidicate a new report.
		 */
		public static const EVENT_NEW_ADHOC_REPORT: String = "NEW";
		/**
		 * Event to save as a  report.
		 */
		public static const EVENT_SAVE_AS_ADHOC_REPORT: String = "SAVE_AS";
		/**
		 * Event to save a report.
		 */
		public static const EVENT_SAVE_ADHOC_REPORT: String = "SAVE";
		/**
		 * Event to delete a report.
		 */
	    public static const EVENT_DELETE_ADHOC_REPORT: String = "DELETE";
		/**
		 * The area to call.
		 */
		public var area: int = 0;
		/**
		 * The id of the report.
		 */
		public var id: String;
		/**
		 * Name of the report.
		 */
		public var name:String; 
		/**
		 * True or false to disable report.
		 */
		public var inactive:Boolean; //true or false
		/**
		 * True or false to make this report editable.
		 */
		public var editable:Boolean; //true or false
		/**
		 * Role associated with this report
		 */
		public var role:String;
		
		/**
		 * The elements associated with this report.
		 */
		public var elements:ArrayCollection = new ArrayCollection();
		
		/**
		 * Event to save a ad hoc report.
		 * @param type the ReportSaveEvent variable
		 * @param callbacks callback function to call upon succesful completion
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 * 
		 */
		public function ReportSaveEvent(type:String, callbacks:IResponder=null, bubbles:Boolean=false, cancelable:Boolean=false)
		{
			super(type, callbacks, bubbles, cancelable);
			this.callbacks=callbacks;
		}
		
		/**
		 * Clone the object. 
		 * @return a duplicate.
		 * 
		 */
		override public function clone():Event
		{
			return new ReportSaveEvent(type,this.callbacks);
		}
		
	}
}