package gov.va.med.edp.control.reports.adhoc
{
	import com.adobe.cairngorm.control.CairngormEvent;
	import gov.va.med.edp.control.AbstractNotificationEvent;
	import flash.events.Event;
	import mx.rpc.IResponder;
	
	/**
	 * Returns the list of reports.
	 * 
	 * @author useruseruser12
	 * 
	 */
	public class ReportListEvent extends AbstractNotificationEvent
	{		
		/**
		 * Type of call.
		 */
		public static const EVENT_GET_REPORT_LIST: String = "getReportList";
		/**
		 * Type of call.
		 */
	    public static const EVENT_GET_BASIC_REPORT_LIST: String = "getBasicReportList";
		/**
		 * The area to call.
		 */
		public var area: int = 0;
		/**
		 * The id of the report.
		 */
		public var id: String;
		/**
		 * True or false to return elements.
		 */
		public var elements:String; //true or false
		
		/**
		 * Event to retrieve a list of ad hoc reports.
		 * @param type the ReportListEvent variable
		 * @param callbacks callback function to call upon succesful completion
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 * 
		 */
		public function ReportListEvent(type:String, callbacks:IResponder=null, bubbles:Boolean=false, cancelable:Boolean=false)
		{
			super(type, callbacks, bubbles, cancelable);
			this.callbacks=callbacks;
		}
		
		/**
		 * Clone the object. 
		 * @return a duplicate.
		 * 
		 */
		override public function clone():Event
		{
			return new ReportListEvent(type,this.callbacks);
		}
		
	}
}