package gov.va.med.edp.control.reports.adhoc
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;
	
	import gov.va.med.edp.control.AbstractNotificationEvent;
	import gov.va.med.edp.vo.reports.adhoc.AdhocReportSearchParametersVO;
	
	import mx.rpc.IResponder;
	
	/**
	 * Event to search an ad hoc report.
	 * 
	 * @author Joseph Lemaire
	 * 
	 */
	public class ReportExecuteEvent extends AbstractNotificationEvent
	{		
		/**
		 * Event to search a report.
		 */
		public static const EVENT_EXECUTE_ADHOC_REPORT: String = "ExecuteReport";
		/**
		 * Event to export a report.
		 */
		public static const EVENT_EXPORT_ADHOC_REPORT: String = "EXPORT";

		public var searchParams:AdhocReportSearchParametersVO;

		/**
		 * Event to save a ad hoc report.
		 * @param type the ReportSaveEvent variable
		 * @param callbacks callback function to call upon succesful completion
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 * 
		 */
		public function ReportExecuteEvent(type:String, callbacks:IResponder=null, bubbles:Boolean=false, cancelable:Boolean=false)
		{
			super(type, callbacks, bubbles, cancelable);
			this.callbacks=callbacks;
		}
		
		/**
		 * Clone the object. 
		 * @return a duplicate.
		 * 
		 */
		override public function clone():Event
		{
			return new ReportExecuteEvent(type,this.callbacks);
		}
		
	}
}
