/**
 *  @author J Lemaire 
 *  
 */

package gov.va.med.edp.control.reports.adhoc
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;
	
	import gov.va.med.edp.control.reports.ReportDownloadEvent;
	import gov.va.med.edp.vo.reports.ReportParamsVO;
	
	/**
	 * The event to trigger retrieval of report elements for a given ad-hoc report.
	 * 
	 *
	 */	
	public class ReportElementEvent extends CairngormEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_GET_REPORT_ELEMENTS:String = "getReportElements";

		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type one of above identifiers
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
		public function ReportElementEvent(type:String, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
		}
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new ReportDownloadEvent(type);
		}
	}
}