package gov.va.med.edp.control.reports.adhoc
{
	import com.adobe.cairngorm.control.CairngormEvent;
	import gov.va.med.edp.control.AbstractNotificationEvent;
	import flash.events.Event;
	import mx.rpc.IResponder;
	import mx.collections.ArrayCollection;
	
	/**
	 * Event to broadcast a change to a ad-hoc report.
	 * 
	 * @author useruseruser12
	 * 
	 */
	public class ReportChangedEvent extends AbstractNotificationEvent
	{		
		/**
		 * Events to propegate a change to a adhoc report.
		 */
		public static const EVENT_ADHOC_REPORT_NAME_CHANGE: String = "NAME";
		public static const EVENT_ADHOC_REPORT_ELEMENTS_CHANGE: String = "ELEMENTS";
		public static const EVENT_ADHOC_REPORT_SEARCH_RESIDENT_CHANGE: String = "RESIDENT";
		public static const EVENT_ADHOC_REPORT_SEARCH_PATIENT_CHANGE: String = "PATIENT";
		public static const EVENT_ADHOC_REPORT_SEARCH_STOP_DATE_CHANGE: String = "STOP";
		public static const EVENT_ADHOC_REPORT_SEARCH_START_DATE_CHANGE: String = "START";
		/**
		 * Name of the report.
		 */
		public var name:String;		
		/**
		 * The elements associated with this report.
		 */
		public var elements:ArrayCollection = new ArrayCollection();
		/**
		 * Patient identifier search paramater of the report.
		 */
		public var patient:String; 
		/**
		 * Resident identifier search paramater of the report.
		 */
		public var resident:String; 
		/**
		 * Start date identifier search paramater of the report.
		 */
		public var startDate:Date; 
		/**
		 * Stop date identifier search paramater of the report.
		 */
		public var stopDate:Date; 
		
		/**
		 * Event to save a ad hoc report.
		 * @param type the ReportChangedEvent variable
		 * @param callbacks callback function to call upon succesful completion
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 * 
		 */
		public function ReportChangedEvent(type:String, callbacks:IResponder=null, bubbles:Boolean=false, cancelable:Boolean=false)
		{
			super(type, callbacks, bubbles, cancelable);
			this.callbacks=callbacks;
		}
		
		/**
		 * Clone the object. 
		 * @return a duplicate.
		 * 
		 */
		override public function clone():Event
		{
			return new ReportChangedEvent(type,this.callbacks);
		}
		
	}
}