/**
*  Report controller 
*/

package gov.va.med.edp.control.reports
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;
	
	import gov.va.med.edp.vo.reports.ReportParamsVO;

	/** 
	 * This is the event used to initiate a certain type of report.
	 * 
	 */ 
	public class ReportEvent extends CairngormEvent
	{/**
		* The Event identifier
		*/
		public static const EVENT_ACTIVITY_REPORT:String = "Activity";
		public static const EVENT_DELAY_REPORT:String = "_Delay";
		public static const EVENT_SUMMARY_REPORT:String = "Summary";
		public static const EVENT_MISSED_OP_REPORT:String = "MissedOp";
		public static const EVENT_ACUITY_REPORT:String = "Acuity";
		public static const EVENT_SHIFT_REPORT:String = "Shift";
		public static const EVENT_PROVIDER_REPORT:String = "Provider";
		public static const EVENT_EXPOSURE_REPORT:String = "Exposure";
		public static const EVENT_PATIENT_INTAKE_REPORT:String = "Intake";
		public static const EVENT_PATIENT_XREF_REPORT:String = "Patient";
		public static const EVENT_VA_ADMISSIONS_REPORT:String = "Admissions";
		public static const EVENT_BVAC_REPORT:String = "Bvac";
		public static const EVENT_ORDERS_BY_ACUITY_REPORT:String = "Orders";
		public static const EVENT_DEMOGRAPHY_REPORT:String = "Demography";
		public static const EVENT_PATIENT_REMOVED_IN_ERROR_REPORT:String = "Removed";
		public static const EVENT_CUSTOM_REPORT:String = "Custom";
		public static const EVENT_CUSTOM_REPORT_CONFIG:String = "CustomConfig";
		public static const EVENT_NONE:String = "";
	
		public var reportParams: ReportParamsVO;
		public var newIndex: int;
		public var role:String;
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type one of above identifiers
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
		public function ReportEvent(type:String, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
		}
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new ReportEvent(type);
		}
	}
}