/* UpdateStaffEvent.as */

package gov.va.med.edp.control.config
{
	import com.adobe.cairngorm.control.CairngormEvent;

	import flash.events.Event;

	import gov.va.med.edp.vo.StaffMemberVO;

	/**
	 * The event to trigger update staff in board configuration.
	 * 
	 *
	 */	
	public class UpdateStaffEvent extends CairngormEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_ADD_STAFF: String = "AddStaff";
		public static const EVENT_REMOVE_STAFF: String = "RemoveStaff";

		public var staff: StaffMemberVO;
		public var newIndex: int;
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type one of above identifier  variable
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
		public function UpdateStaffEvent(type:String, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
		}
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new UpdateStaffEvent(type);
		}
		/**
		 * The main call add staff
		 * 
		 * @param staff  of type StaffMemberVO  variable
		 * @param role id the role to add
		 * 
		 */
		
        public static function dispatchAdd(staff : StaffMemberVO, role : String) : void {
        	if (staff == null) return;
            var addEvent: UpdateStaffEvent = new UpdateStaffEvent(EVENT_ADD_STAFF);
			addEvent.staff = staff;
			addEvent.staff.role = role;
			addEvent.staff.changed = true;
			addEvent.dispatch();
        }
		/**
		 * The main call remove staff
		 * 
		 * @param staff  of type StaffMemberVO  variable
		 * 
		 * 
		 */
         public static function dispatchRemove(staff : StaffMemberVO) : void {
         	if (staff == null) return;
            var removeEvent: UpdateStaffEvent = new UpdateStaffEvent(EVENT_REMOVE_STAFF);
			removeEvent.staff = staff;
			removeEvent.dispatch();
        }
    }
}