/* MatchPersonEvent.as */

package gov.va.med.edp.control.config
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;

	/**
	 * The event to trigger match staff in board configuration.
	 * 
	 *
	 */	
	public class MatchPersonEvent extends CairngormEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_MATCH_PERSON : String = "matchPerson";
		public static const EVENT_MATCH_STAFF:String = "matchStaff";

		public var partial: String;
		public var personType: String;
		public var newIndex: int;
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type the EVENT_MATCH_PERSON variable
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */	
		public function MatchPersonEvent(type:String, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
		}
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new MatchPersonEvent(type);
		}
	}
}