/* ConfigurationEvent.as */

package gov.va.med.edp.control.config
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;

	/**
	 * The event to trigger major changes to board configuration.
	 * 
	 *
	 */	
	public class ConfigurationEvent extends CairngormEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_LOAD_CONFIGURATION: String = "loadConfiguration";
		public static const EVENT_LOAD_SELECTION_CONFIG: String = "loadSelectionConfig";
		public static const EVENT_SAVE_SELECTION_CONFIG: String = "saveSelectionConfig";
		public static const EVENT_SAVE_COLOR_CONFIG: String = "saveColorConfig";
		public static const EVENT_LOAD_STAFF_CONFIG: String = "loadStaffConfig";
		public static const EVENT_SAVE_STAFF_CONFIG: String = "saveStaffConfig";
		public static const EVENT_SAVE_PARAM_CONFIG: String = "saveParamConfig";
		public static const EVENT_BED_MODIFIED: String = "bedModified";
		public static const EVENT_BOARD_MODIFIED: String = "boardModified";
		public static const EVENT_COLOR_MODIFIED: String = "colorModified";
		public static const EVENT_PARAM_MODIFIED: String = "paramModified";
		public static const EVENT_PARAM_MODIFIED_RESET: String = "paramModifiedReset";
		public static const EVENT_SELECTION_MODIFIED: String = "selectionModified";
		public static const EVENT_STAFF_MODIFIED: String = "staffModified";
		public var newIndex: int;
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type identifier above variable
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
		
		public function ConfigurationEvent(type: String, bubbles: Boolean=true,
			cancelable: Boolean=false)
		{
			super(type, bubbles, cancelable);
		}
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new ConfigurationEvent(type);
		}
	}
}
