/* ConfigChangeColumnEvent.as */

package gov.va.med.edp.control.config
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;

	/**
	 * The event to trigger change a column in board configuration.
	 * 
	 *
	 */	
	public class ConfigChangeColumnEvent extends CairngormEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_CONFIG_CHANGE_COLUMN_SEQ: String = "configChangeColumnSequence";
		public static const EVENT_CONFIG_CHANGE_COLUMN_WIDTH: String = "configChangeColumnWidth";
		public static const EVENT_CONFIG_CHANGE_ROW_COLOR: String = "configChangeRowColor"
				
		public var oldIndex: int;
		public var newIndex: int;
		public var widths: Array = [];
		public var rowColor: String;
		
		
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type the identifiers above variable
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
		public function ConfigChangeColumnEvent(type:String, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
		}
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new ConfigChangeColumnEvent(type);
		}
	}
}
