package gov.va.med.edp.control.config
{
    import flash.events.Event;
    
    import gov.va.med.edp.vo.ColorSelectionVO;
    
	/**
	 * The event to trigger changing an entity's color in board configuration.
	 * 
	 *
	 */	
    public class ColorChangedEvent extends Event
    {
		/**
		 * The Event identifier
		 */
        public static var COLOR_CHANGED:String = "colorChange";
        
        public var color:ColorSelectionVO;
		public var newIndex: int;
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type the COLOR_CHANGED variable
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
        public function ColorChangedEvent(color:ColorSelectionVO)
        {
            // pass type and set bubbles (2nd param) to true
            super(COLOR_CHANGED, true, true);
            this.color = color;
        }
    }
}