/* ChangeBedSequenceEvent.as */

package gov.va.med.edp.control.config
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;

	/**
	 * The event to trigger changing a bed in board configuration.
	 * 
	 *
	 */	
	public class ChangeBedSequenceEvent extends CairngormEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_CHANGE_BED_SEQUENCE: String = "changeBedSequence"
				
		public var oldIndex: int;
		public var newIndex: int;
	
		
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type the EVENT_CHANGE_BED_SEQUENCE variable
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
		public function ChangeBedSequenceEvent(type:String, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
		}
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new ChangeBedSequenceEvent(type);
		}
	}
}