/* BoardConfigEvent.as */

package gov.va.med.edp.control.config
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;
	
	import mx.collections.ArrayCollection;

	/**
	 * The event to trigger adding a new board to board configuration.
	 * 
	 *
	 */	
	public class BoardConfigEvent extends CairngormEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_ADD_CONFIG_BOARD: String = "addBoardConfig";
		public static const EVENT_LOAD_CONFIG_BOARD: String = "loadBoardConfig";
		public static const EVENT_SAVE_CONFIG_BOARD: String = "saveBoardConfig";
		
		public var boardID: int;
		public var boardName: String;
		public var newIndex: int;
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type one of above identifiers
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
		public function BoardConfigEvent(type:String, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
		}
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new BoardConfigEvent(type);
		}
	}
}