package gov.va.med.edp.control
{
	import flash.events.Event;
	import com.adobe.cairngorm.control.CairngormEvent;
	import gov.va.med.edp.vo.VitalsVO;
	import mx.rpc.IResponder;
	
	/**
	 * Defines the Update Vitals Event for the Cairngorm evironment
	 */
	public class UpdateVitalsEvent extends AbstractNotificationEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_SAVE_VITALS:String = "updateVitals";
				
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type the EVENT_SAVE_VITALS variable
		 * @param callbacks callback function to call upon succesful completion
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
		public function UpdateVitalsEvent(type:String, callbacks:IResponder=null, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, callbacks, bubbles, cancelable);
			this.callbacks=callbacks;
		}
		
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new UpdateVitalsEvent(type,this.callbacks);
		}
	}
}