/* UpdateDemogEvent.as */

package gov.va.med.edp.control
{
	import flash.events.Event;
	import com.adobe.cairngorm.control.CairngormEvent;
	import gov.va.med.edp.vo.reports.PtDemographicsVO;
	
	/**
	 * Defines the Update Demography Event for the Cairnform evironment
	 */
	public class UpdateDemogEvent extends CairngormEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_SAVE_DEMOG:String = "updateDemog";
		
		public var value: *;
		
		/**
		 * The Demography class to be worked on
		 */ 
		public var demog : PtDemographicsVO;
		
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type the EVENT_SAVE_DEMOG variable
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
		public function UpdateDemogEvent(type:String, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
		}
		
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new UpdateDemogEvent(type);
		}
	}
}