/*  TrackingEvent.as */

package gov.va.med.edp.control
{
	import com.adobe.cairngorm.control.CairngormEvent;	
	import flash.events.Event;
	import mx.rpc.IResponder;

	/**
	 * The event to trigger major events in the EDIS workflow.
	 * 
	 *
	 */	
	public class TrackingEvent extends CairngormEvent
	{/**
		* The Event identifier
		*/
		public static const EVENT_START_TIMER: String = "startTimer";
		public static const EVENT_STOP_TIMER: String = "stopTimer";
		public static const EVENT_INIT_TRACKING: String = "initTracking";
		public static const EVENT_CANCEL_EDIT: String = "cancelEdit";
		public static const EVENT_SAVE_LOG_ENTRY: String = "saveLogEntry";
		public static const EVENT_DELETE_STUB_ENTRY: String = "deleteStubEntry";
		public static const EVENT_REFRESH_LOG_SELECTOR: String = "refreshLogSelector";
		public static const EVENT_RESTORE_LOG_ENTRY: String = "restoreLogEntry";				
		public static const EVENT_SAVE_AND_REFRESH_LOG_SELECTOR: String = "saveRefreshLogEntry";
		public static const EVENT_SAVE_AND_REFRESH_DISPLAYBOARD: String = "saveRefreshDisplayboard";
		public static const EVENT_RESET_DATETIME: String = "resetDateTime";

		public var callbacks:IResponder=null;

		
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type one of above identifiers
		 * @param callbacks callback function to call upon succesful completion
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
		public function TrackingEvent(type:String, callbacks:IResponder=null, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
			this.callbacks=callbacks;

		}
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new TrackingEvent(type);
		}
	}
}