/* SortHeaderEvent.as */

package gov.va.med.edp.control
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;

	/**
	 * The event to trigger display header sorting.
	 * 
	 *
	 */	
	public class SortHeaderEvent extends CairngormEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_SORT_LOG_SELECTOR : String = "sortLogSelector";
		public static const EVENT_SORT_DISPLAY_BOARD : String = "sortDisplayBoard";
		
		public var sortField: String;
		public var sortDescending: Boolean;
			
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type one of above identifiers
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
		public function SortHeaderEvent(type:String, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
		}
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new SortHeaderEvent(type);
		}
	}
}