package gov.va.med.edp.control
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;
	
	import gov.va.med.edp.pt.demog.model.PatientSelectVO;
	
	import mx.collections.ArrayCollection;
	
	import mx.rpc.IResponder;
	
	/**
	 * The event to trigger getting lab data for a patient
	 */
	public class LabTrendEvent extends AbstractNotificationEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_LAB_TREND:String = "getLabs";
		public static const EVENT_LAB_MICROBIOLOGY_TREND:String = "MI";
		public static const EVENT_LAB_CHEM_TREND:String = "CH";
		public static const EVENT_LAB_CHEM_TREND_TEST_IDS:String = "testIDS";
		public static const EVENT_LAB_CHEM_TRANSACTION:String = "chem_transaction";		
		public var patient: PatientSelectVO;
		public var xml:XML;
		public var testIds: String;
		public var logID:Number = 0;

		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type one of above identifiers
		 * @param callbacks callback function to call upon succesful completion
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
		public function LabTrendEvent(type:String, callbacks:IResponder=null, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, callbacks, bubbles, cancelable);
			this.callbacks=callbacks;
		}
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new LabTrendEvent(type, this.callbacks);
		}
	}
}