/* InitAppEvent.as */

package gov.va.med.edp.control
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;

	/**
	 * The event to trigger initialization of the application.
	 * 
	 *
	 */	
	public class InitAppEvent extends CairngormEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_INIT_APP:String = "initApp";
		
		public static const SERVICE_USE_VLJ: int = 0;
		public static const SERVICE_USE_CSP: int = 1
		public static const SERVICE_USE_MOCK: int = 2;	
		
		public static const SITE_ID: String = "siteId";
		
		public var server: String = "";
		public var mode: int = 0;
		public var token: String = "";
		public var appName: String = "";
		public var contextRoot: String = "";
		public var protocol: String = "";
		public var helpContextRoot: String = "";
		public var siteId: String = "";
		public var board: String = "";
		public var debug: String = "";
		public var areaName: String = "";
		public var area: int = 0;
		public var timeout: Boolean = false;

		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type one of above identifiers
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
        public function InitAppEvent(type:String, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
		}
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new InitAppEvent(type);
		}
	}
}