package gov.va.med.edp.control
{
	import flash.events.Event;
	import com.adobe.cairngorm.control.CairngormEvent;
	import gov.va.med.edp.vo.VitalsVO;
	import mx.rpc.IResponder;
	
	/**
	 * Defines the Update Vitals Event for the Cairngorm evironment
	 */
	public class GetVitalsEvent extends AbstractNotificationEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_GET_VITALS:String = "getVitals";
		
		/**
		 * The Vitals class to be worked on
		 */ 
		public var vitals : VitalsVO;
		
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type the EVENT_GET_VITALS variable
		 * @param callbacks callback function to call upon succesful completion
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
		public function GetVitalsEvent(type:String, callbacks:IResponder=null, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, callbacks, bubbles, cancelable);
			this.callbacks=callbacks;
		}
		
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new GetVitalsEvent(type,this.callbacks);
		}
	}
}