/* DisplayBoardEvent.as */

package gov.va.med.edp.control
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;

	/**
	 * The event to trigger display board events, such as a refresh.
	 * 
	 *
	 */	
	public class DisplayBoardEvent extends CairngormEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_INIT_DISPLAY_BOARD:String = "initDisplayBoard";
		public static const EVENT_REFRESH_DISPLAY_BOARD:String = "refreshDisplayBoard";
		
		public var name: String;
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type one of above identifiers
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */
		public function DisplayBoardEvent(type:String, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
		}
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new DisplayBoardEvent(type);
		}
	}
}