/* ClearUnsavedViewsModelEvent.as */

package gov.va.med.edp.control
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;

	/**
	 * The event to trigger clearing unsaved views in the current model.
	 * 
	 *
	 */	
	public class ClearUnsavedViewsModelEvent extends CairngormEvent
	{
		/**
		 * The Event identifier
		 */
		public static const EVENT_CLEAR_UNSAVED_VIEWS:String = "clearUnsavedViewsModel";
		/**
		 * The main call to the Cairngorm environment
		 * 
		 * @param type EVENT_CLEAR_UNSAVED_VIEWS
		 * @param bubbles tells Cairngorm to bubble up the results through any listener
		 * @param cancelable tells Cairngorm whether this can be cancelled
		 */	
		public function ClearUnsavedViewsModelEvent(type:String, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
		}
		/**
		 * Clone the event
		 */
		override public function clone():Event
		{
			return new ClearUnsavedViewsModelEvent(type);
		}
		/**
		 * clear view
		 */
        public static function dispatchClearUnsavedViews():void {
            var clearUnsavedViewsEvent: ClearUnsavedViewsModelEvent = new ClearUnsavedViewsModelEvent(ClearUnsavedViewsModelEvent.EVENT_CLEAR_UNSAVED_VIEWS);
		    clearUnsavedViewsEvent.dispatch(); 
        }
    }
}