package gov.va.med.edp.command.worksheet
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.worksheet.GetWorkSheetDelegate;
	import gov.va.med.edp.business.worksheet.LoadWorkSheetDelegate;
	import gov.va.med.edp.business.worksheet.LoadWorkSheetListDelegate;
	import gov.va.med.edp.business.worksheet.SaveWorkSheetDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.control.worksheet.SaveWorkSheetEvent;
	import gov.va.med.edp.factory.WorkSheetFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.model.worksheet.SectionModel;
	import gov.va.med.edp.model.worksheet.WorkSheetModel;
	import gov.va.med.edp.vo.worksheet.SectionVO;
	import gov.va.med.edp.vo.worksheet.WorkSheetVO;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	
	/**
	 * Command to load worksheets per role. 
	 * @author Joseph Lemaire
	 */
	public class SaveWorkSheetCommand extends AbstractResponderCommand implements ICommand, IResponder
	{		
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/**
		 * Constructor.  
		 */
		public function SaveWorkSheetCommand()
		{
			//super();
		}
		
		public function execute(event:CairngormEvent):void
		{
			var delegate:SaveWorkSheetDelegate = new SaveWorkSheetDelegate(this);		
			var saveEvent: SaveWorkSheetEvent = SaveWorkSheetEvent(event);
			var bool:Boolean = false;
			if (saveEvent.disabled) {
				bool = (saveEvent.disableMode == "enable") ? false : true;
			}
			delegate.saveWorksheet(model.logArea, saveEvent.worksheet, bool, saveEvent.deletion);
		}
		
		override public function result(data:Object):void
		{

		}
		
		
		/**
		 * Message that is returned when a fault occurs.
		 * @param faultEvent - The event associated with the fault.
		 * @return String - The message.
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Saving worksheet failed: " + super.getFaultMessage(faultEvent);
		}
		
		/**
		 * This method is called when a fault occurs.
		 * @param info The information regarding the fault.
		 * 
		 */
		override public function fault(info:Object):void
		{
			super.fault(info);
		}
		
	}
}