package gov.va.med.edp.command.worksheet
{
	import com.adobe.cairngorm.control.CairngormEvent;
	import gov.va.med.edp.business.worksheet.LoadWorkSheetListDelegate;
	import gov.va.med.edp.control.worksheet.LoadWorkSheetEvent;
	import gov.va.med.edp.factory.WorkSheetFactory;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.controls.Alert;
	
	/**
	 * Load the worksheet list per role
	 * @author useruseruser12
	 * 
	 */
	public class LoadWorkSheetListViewCommand extends LoadWorkSheetListCommand
	{
		/**
		 * 
		 * 
		 */
		public function LoadWorkSheetListViewCommand()
		{
			super();
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		override public function execute(event:CairngormEvent):void
		{
			
			super.cacheCaller(event);
			
			delegate = new LoadWorkSheetListDelegate(this);		
			loadEvent = LoadWorkSheetEvent(event);
			var role:String = loadEvent.role;
			
			//Alert.show("LoadWorkSheetListViewCommand-> model.logArea = " + model.logArea + " , role = " + role);
			
			delegate.loadWorksheetList(model.logArea, role);
		}
		
		/**
		 * 
		 * @param data
		 * 
		 */
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;			
						
			model.workSheetList = WorkSheetFactory.buildWorksheetListFromXML(xml.worksheets.role.worksheet);

			notifyCaller(data);
			
		}
		
		
		/**
		 * Message that is returned when a fault occurs.
		 * @param faultEvent - The event associated with the fault.
		 * @return String - The message.
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "LoadWorkSheetListViewCommand failed: " + super.getFaultMessage(faultEvent);
		}
		
	}
}