package gov.va.med.edp.command.worksheet
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.worksheet.LoadWorkSheetDelegate;
	import gov.va.med.edp.business.worksheet.LoadWorkSheetListDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.control.worksheet.LoadWorkSheetEvent;
	import gov.va.med.edp.factory.WorkSheetFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.model.worksheet.SectionModel;
	import gov.va.med.edp.model.worksheet.WorkSheetModel;
	import gov.va.med.edp.vo.worksheet.SectionVO;
	import gov.va.med.edp.vo.worksheet.WorkSheetVO;
	import gov.va.med.edp.command.AbstractNotificationCommand;
	import mx.collections.ArrayCollection;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.utils.ObjectUtil;
	
	/**
	 * Command to load worksheets per role. 
	 * @author Joseph Lemaire
	 */
	public class LoadWorkSheetListCommand extends AbstractNotificationCommand
	{		
		protected var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		protected var delegate:LoadWorkSheetListDelegate;
		protected var loadEvent: LoadWorkSheetEvent;
		
		/**
		 * Constructor.  
		 */
		public function LoadWorkSheetListCommand()
		{
			super();
		}
		
		public override function execute(event:CairngormEvent):void
		{
				
			model.roleWorksheetLoaded = false;

			delegate = new LoadWorkSheetListDelegate(this);		
			loadEvent = LoadWorkSheetEvent(event);
			var role:String = loadEvent.role;
			delegate.loadWorksheetList(model.logArea, role);
		}
		
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;
			
			var nodeList:XMLList = xml.worksheets.role;
			
			model.roleWorksheets = WorkSheetFactory.buildRoleWorksheet(nodeList);
			model.roleWorksheetLoaded = true;
		}
		
		
		/**
		 * Message that is returned when a fault occurs.
		 * @param faultEvent - The event associated with the fault.
		 * @return String - The message.
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Loading worksheet list failed: " + super.getFaultMessage(faultEvent);
		}
		
		/**
		 * This method is called when a fault occurs.
		 * @param info The information regarding the fault.
		 * 
		 */
		override public function fault(info:Object):void
		{
			super.fault(info);
		}
		
	}
}