package gov.va.med.edp.command.worksheet
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.worksheet.LoadWorkSheetDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.factory.WorkSheetFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.model.worksheet.SectionModel;
	import gov.va.med.edp.model.worksheet.WorkSheetModel;
	import gov.va.med.edp.vo.worksheet.SectionVO;
	import gov.va.med.edp.vo.worksheet.WorkSheetVO;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	
	/**
	 * Command to load a specific woorksheet into the system. 
	 * @author useruseruser12
	 */
	public class LoadWorkSheetCommand extends AbstractResponderCommand implements ICommand, IResponder
	{		
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		
		public var dummyxml:XML = <results>	<workSheet>
		<name>Visit</name>
		<institution>64</institution>
		<area>0</area>
		<type>V</type>
		<role>Nurse</role>
		<disabled>1</disabled>
		<section name="Complaint" initialOpen="true" sequence="0">
			<component id="1" name="complaint" label="Complaint for Display Board"
				dataProvider="" value="logEdit.entry.complaint" available="true"
				dependentOn="" visibilityTrigger="" editable="true"
				type="gov.va.med.edp.view.worksheet.WorkSheetTextInput"
				sequence="2" includeInSummary="true" summaryLabel="Complaint" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="">
					<param name="logID" type="string" />
				</loadRoutine>
			</component>
			<component id="1" name="longComplaint" label="Long Complaint (optional)"
				dataProvider="" value="logEdit.entry.longComplaint" available="true"
				dependentOn="" visibilityTrigger="" editable="false"
				type="gov.va.med.edp.view.worksheet.WorkSheetTextInput"
				sequence="1" includeInSummary="false" summaryLabel="Long Complaint" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="">
					<param name="logID" type="string" />
				</loadRoutine>
			</component>
			<component id="0" name="arrival" label="Source"
				dataProvider="logEdit.arrivals" value="logEdit.entry.arrival"
				available="true" dependentOn="" visibilityTrigger="" editable="true"
				type="gov.va.med.edp.view.worksheet.WorkSheetValueComboBox"
				sequence="0" includeInSummary="true" summaryLabel="Source" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="">
					<param name="logID" type="string" />
				</loadRoutine>
			</component>
		</section>
		<section name="Status/Responsibility" initialOpen="false" sequence="1">
			<component id="1" name="bed" label="Room / Area"
				dataProvider="logEdit.beds" value="logEdit.entry.bed" available="true"
				dependentOn="" visibilityTrigger="" editable="true"
				type="gov.va.med.edp.view.worksheet.WorkSheetValueComboBox"
				sequence="0" includeInSummary="true" summaryLabel="Room / Area" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="">
					<param name="logID" type="string" />
				</loadRoutine>
			</component>
			<component id="1" name="acuity" label="Acuity"
				dataProvider="logEdit.acuities" value="logEdit.entry.acuity"
				available="true" dependentOn="" visibilityTrigger="" editable="false"
				type="gov.va.med.edp.view.worksheet.WorkSheetValueComboBox"
				sequence="1" includeInSummary="true" summaryLabel="Acuity" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="">
					<param name="logID" type="string" />
				</loadRoutine>
			</component>
			<component id="1" name="status" label="Status"
				dataProvider="logEdit.statuses" value="logEdit.entry.status"
				available="true" dependentOn="" visibilityTrigger="" editable="true"
				type="gov.va.med.edp.view.worksheet.WorkSheetValueComboBox"
				sequence="2" includeInSummary="true" summaryLabel="Status" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="">
					<param name="logID" type="string" />
				</loadRoutine>
			</component>
			<component id="1" name="provider" label="Provider"
				dataProvider="logEdit.providers" value="logEdit.entry.provider"
				available="true" dependentOn="" visibilityTrigger="" editable="true"
				type="gov.va.med.edp.view.worksheet.WorkSheetValueComboBox"
				sequence="3" includeInSummary="true" summaryLabel="Provider" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="">
					<param name="logID" type="string" />
				</loadRoutine>
			</component>
			<component id="1" name="resident" label="Resident"
				dataProvider="logEdit.residents" value="logEdit.entry.resident"
				available="true" dependentOn="" visibilityTrigger="logEditParams.promptResidents" editable="true"
				type="gov.va.med.edp.view.worksheet.WorkSheetValueComboBox"
				sequence="4" includeInSummary="true" summaryLabel="Resident" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="">
					<param name="logID" type="string" />
				</loadRoutine>
			</component>
			<component id="1" name="clinic" label="Clinic"
				dataProvider="logEdit.clinics" value="logEdit.entry.clinic"
				available="true" dependentOn="" visibilityTrigger="logEditParams.promptClinics" editable="true"
				type="gov.va.med.edp.view.worksheet.WorkSheetValueComboBox"
				sequence="5" includeInSummary="true" summaryLabel="Clinic" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="">
					<param name="logID" type="string" />
				</loadRoutine>
			</component>
		</section>
		<section name="Disposition" initialOpen="true" sequence="2">
			<component id="1" name="comment" label="Comments"
				dataProvider="" value="logEdit.entry.comment" available="true"
				dependentOn="" visibilityTrigger="" editable="true"
				type="gov.va.med.edp.view.worksheet.WorkSheetTextInput"
				sequence="0" includeInSummary="false" summaryLabel="Comments" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="">
					<param name="logID" type="string" />
				</loadRoutine>
			</component>
			<component id="1" name="disposition" label="Disposition"
				dataProvider="logEdit.dispositions" value="logEdit.entry.disposition"
				available="true" dependentOn="" visibilityTrigger="" editable="true"
				type="gov.va.med.edp.view.worksheet.WorkSheetValueComboBox"
				sequence="1" includeInSummary="true" summaryLabel="Disposition" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="">
					<param name="logID" type="string" />
				</loadRoutine>
			</component>
			<component id="1" name="delay" label="Delay Reason"
				dataProvider="logEdit.delays" value="logEdit.entry.delay" available="true"
				dependentOn="" visibilityTrigger="logEdit.entry.requireDelay"
				editable="true" type="gov.va.med.edp.view.worksheet.WorkSheetValueComboBox"
				sequence="2" includeInSummary="true" summaryLabel="Delay Reason" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="">
					<param name="logID" type="string" />
				</loadRoutine>
			</component>
			<component id="1" name="diagnosisCoded" label="Diagnosis Coded"
				dataProvider="" value="" available="true" dependentOn="diagnosisFreeText"
				visibilityTrigger="logEditParams.codedDiagnosis" editable="true"
				type="gov.va.med.edp.cpe.view.log.DiagnosesCoded" 
				sequence="3" includeInSummary="true" summaryLabel="Diagnosis" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="">
					<param name="logID" type="string" />
				</loadRoutine>
			</component>
			<component id="1" name="diagnosisFreeText" label="Diagnosis Free Text"
				dataProvider="" value="" available="true" dependentOn="diagnosisCoded"
				visibilityTrigger="logEditParams.freeDiagnosis" editable="true"
				type="gov.va.med.edp.cpe.view.log.DiagnosesFreeText"
				sequence="4" includeInSummary="true" summaryLabel="Diagnosis" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="">
					<param name="logID" type="string" />
				</loadRoutine>
			</component>
		</section>
	</workSheet>
	<workSheet>
		<name>Assess</name>
		<institution>64</institution>
		<area>0</area>
		<type>V</type>
		<role>Provider</role>
		<disabled>1</disabled>
		<section name="Labs" initialOpen="true" sequence="0">
			<component id="1" name="labsView" label="Labs"
				dataProvider="" value="" available="true" dependentOn=""
				visibilityTrigger="" editable="true"
				type="gov.va.med.edp.view.worksheet.WorkSheetDataGridWidget"
				sequence="0" includeInSummary="true" summaryLabel="Labs" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="gov.va.med.edp.control.LabTrendEvent">
					<param name="type" type="String" value="testIDS" />
				</loadRoutine>
			</component>
		</section>
		<section name="Vitals" initialOpen="false" sequence="1">
			<component id="1" name="vitalsView" label="Vitals"
				dataProvider="" value="" available="true" dependentOn=""
				visibilityTrigger="" editable="true"
				type="gov.va.med.edp.view.worksheet.WorkSheetDataGridWidget"
				sequence="0" includeInSummary="true" summaryLabel="Vitals" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="gov.va.med.edp.control.GetVitalsEvent">
					<param name="type" type="String" value="getVitals" />
				</loadRoutine>
			</component>
		</section>
		<section name="Active Problems" initialOpen="false" sequence="2">
			<component id="1" name="activeProblemsView" label="Active Problems"
				dataProvider="" value="" available="true" dependentOn=""
				visibilityTrigger="" editable="true"
				type="gov.va.med.edp.view.worksheet.WorkSheetDataGridWidget"
				sequence="0" includeInSummary="true" summaryLabel="Active Problems" summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="gov.va.med.edp.control.DetailsEvent">
					<param name="type" type="String" value="PLIST" />
				</loadRoutine>
			</component>
		</section>
		<section name="Active Medications" initialOpen="false" sequence="3">
			<component id="1" name="activeMedicationsView" label="Active Medications"
				dataProvider="activeMeds" value="" available="true" dependentOn=""
				visibilityTrigger="" editable="true"
				type="gov.va.med.edp.view.worksheet.WorkSheetDataGridWidget"
				sequence="0" includeInSummary="true" summaryLabel="Active Medications"
				summaryOrder="1">
				<saveRoutine name="saveRoutine1">
					<param name="logID" type="string" />
				</saveRoutine>
				<loadRoutine name="gov.va.med.edp.control.DetailsEvent">
					<param name="type" type="String" value="MEDS" />
				</loadRoutine>
			</component>
		</section>
	</workSheet></results>
		
		/**
		 * Constructor.  
		 */
		public function LoadWorkSheetCommand()
		{
			//super();
		}
		
		public function execute(event:CairngormEvent):void
		{
			var delegate:LoadWorkSheetDelegate = new LoadWorkSheetDelegate(this);		
		
			delegate.loadWorksheet("TEST");
			
			//parseData();
			
		}
		
		/*override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;
					
			var sectionModels:ArrayCollection = new ArrayCollection();
			
			model.workSheetModel.setAbstractWorkSheetVO(WorkSheetFactory.buildWorkSheet(xml));
									
			
			var sectionsVO:ArrayCollection = WorkSheetFactory.buildSections(xml.sections.section);
			
			for each (var sectionVO: SectionVO in sectionsVO) {
				
				var section:SectionModel = new SectionModel();
				
				section.setSectionVO(sectionVO);
				
				//section.setComponentArray(WorkSheetFactory.createComponentsFromXML(item.components));
				
				sectionModels.addItem(section);
				
			}
								
			
			model.workSheetModel.setSections(sectionModels);
			
			model.workSheetLoaded = true;
			
		}
		*/
		
		private function parseData():void
		{
			
			var nodeList:XMLList = dummyxml.workSheet;
			
			for each (var item: XML in nodeList) {
								
				var workSheetModel:WorkSheetModel = new WorkSheetModel(WorkSheetFactory.buildWorkSheet(item));
				
				model.workSheetModels.addItem(workSheetModel);
				
			}
			
			model.workSheetLoaded = true;
			
		}
		
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;
			
			var nodeList:XMLList = xml.workSheet;
			
			//var nodeList:XMLList = dummyxml.workSheet;
			
			for each (var item: XML in nodeList) {
						
				var workSheetModel:WorkSheetModel = new WorkSheetModel(WorkSheetFactory.buildWorkSheet(item));
							
				model.workSheetModels.addItem(workSheetModel);
				
			}
			
			model.workSheetLoaded = true;
			
		}
		
		
		/**
		 * Message that is returned when a fault occurs.
		 * @param faultEvent - The event associated with the fault.
		 * @return String - The message.
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Loading worksheet failed: " + super.getFaultMessage(faultEvent);
		}
		
		/**
		 * This method is called when a fault occurs.
		 * @param info The information regarding the fault.
		 * 
		 */
		override public function fault(info:Object):void
		{
			super.fault(info);
		}
				
	}
}