package gov.va.med.edp.command.worksheet
{
	import com.adobe.cairngorm.control.CairngormEvent;
	import gov.va.med.edp.business.worksheet.LoadWorkSheetListDelegate;
	import gov.va.med.edp.control.worksheet.LoadWorkSheetEvent;
	import gov.va.med.edp.factory.WorkSheetFactory;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.controls.Alert;
	import gov.va.med.edp.command.AbstractSequenceNotificationCommand;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.worksheet.WorkSheetListVO;
	
	/**
	 * Load the required subset of worksheets
	 * @author useruseruser12
	 * 
	 */
	public class LoadRequiredWorkSheetsCommand extends AbstractSequenceNotificationCommand
	{
		
		protected var model:TrackingModelLocator = TrackingModelLocator.getInstance();		
		protected var delegate:LoadWorkSheetListDelegate;
		protected var loadEvent: LoadWorkSheetEvent;
		
		/**
		 * 
		 * 
		 */
		public function LoadRequiredWorkSheetsCommand()
		{
			super();
			this.nextEvent = new LoadWorkSheetEvent(LoadWorkSheetEvent.EVENT_GET_WORKSHEET_SEQUENCE);
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		override public function execute(event:CairngormEvent):void
		{
			
			super.execute(event);
			
			delegate = new LoadWorkSheetListDelegate(this);		
			loadEvent = LoadWorkSheetEvent(event);
			var role:String = loadEvent.role;
			
			//Alert.show("LoadRequiredWorkSheetsCommand-> model.logArea = " + model.logArea + " , role = " + role);
			
			delegate.loadWorksheetList(model.logArea, role);
		}
		
		/**
		 * 
		 * @param data
		 * 
		 */
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;			
						
			model.workSheetList = WorkSheetFactory.buildWorksheetListFromXML(xml.worksheets.role.worksheet);

			//notifyCaller(data);
			
			if(this.nextEvent != null) {
				
				var workSheetListVO:WorkSheetListVO = model.getNextRequiredWorksheet();
				
				if(workSheetListVO != null) {
				
					(this.nextEvent as LoadWorkSheetEvent).worksheetID = String(workSheetListVO.id);
					(this.nextEvent as LoadWorkSheetEvent).worksheetName = workSheetListVO.worksheetName;				
					this.executeNextCommand();
				
				}				
			}
		}
		
		
		/**
		 * Message that is returned when a fault occurs.
		 * @param faultEvent - The event associated with the fault.
		 * @return String - The message.
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "LoadRequiredWorkSheetsCommand failed: " + super.getFaultMessage(faultEvent);
		}
		
	}
}