package gov.va.med.edp.command.worksheet
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.worksheet.GetWorkSheetDelegate;
	import gov.va.med.edp.control.worksheet.LoadWorkSheetEvent;
	import gov.va.med.edp.factory.WorkSheetFactory;
	import gov.va.med.edp.model.worksheet.WorkSheetModel;
	
	import mx.controls.Alert;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import gov.va.med.edp.business.Services;
	import com.adobe.cairngorm.business.ServiceLocator;
	import gov.va.med.edp.control.InitAppEvent;
	/**
	 * Loads a worksheet view given a role.  This essentially adds a worksheet to the app.
	 *  
	 * @author useruseruser12
	 * 
	 */
	public class GetWorksheetViewCommand extends GetWorkSheetCommand
	{
		private var debug:Boolean = false;
		private var worksheetName:String = "";
		/**
		 * Constructor. 
		 */
		public function GetWorksheetViewCommand()
		{
			super();
			if (Services(ServiceLocator.getInstance()).callMode == InitAppEvent.SERVICE_USE_MOCK) {
				debug = true;	
			}
		}
		
		/**
		 * Execution of the command.
		 * @param event
		 * 
		 */
		override public function execute(event:CairngormEvent):void
		{
			
			delegate  = new GetWorkSheetDelegate(this);		
			loadEvent = LoadWorkSheetEvent(event);
			
			var worksheetID:String = loadEvent.worksheetID;
			worksheetName = loadEvent.worksheetName;
			
			//Alert.show("GetWorksheetViewCommand-> worksheet = " + worksheetName);
			
			delegate.getWorksheet(worksheetID,"1");
		}
		
		/**
		 * Result of the command.
		 * @param data
		 * 
		 */
		override public function result(data:Object):void
		{		
			var xml:XML = ResultEvent(data).result as XML;			
			var nodeList:XMLList;
			
			if (debug && (worksheetName == "Assess")) {
				nodeList = xml.worksheet_test.worksheet;
			} else if (debug && (worksheetName == "Edit Closed")) {
				nodeList = xml.worksheet_test1.worksheet;
			} else {
				nodeList = xml.worksheet;
			}
			
			//var nodeList:XMLList = xml.worksheet;
						
			//Alert.show("GetWorksheetViewCommand-> result = " + xml);
			
			for each (var item: XML in nodeList) {
				
				var workSheetModel:WorkSheetModel = new WorkSheetModel(WorkSheetFactory.buildWorkSheet(item));				
				model.addWorksheetModel(workSheetModel);
				
			}			
		}
		
		
		/**
		 * Message that is returned when a fault occurs.
		 * @param faultEvent - The event associated with the fault.
		 * @return String - The message.
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "GetWorksheetViewCommand failed: " + super.getFaultMessage(faultEvent);
		}
	}
}