package gov.va.med.edp.command.worksheet
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.worksheet.GetWorkSheetDelegate;
	import gov.va.med.edp.command.AbstractSequenceNotificationCommand;
	import gov.va.med.edp.control.worksheet.LoadWorkSheetEvent;
	import gov.va.med.edp.factory.WorkSheetFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.model.worksheet.WorkSheetModel;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	
	import gov.va.med.edp.business.Services;
	import com.adobe.cairngorm.business.ServiceLocator;
	import gov.va.med.edp.control.InitAppEvent;
	import mx.controls.Alert;
	import gov.va.med.edp.vo.worksheet.WorkSheetListVO;
	
	/**
	 * Command to load all required worksheets requested. 
	 * @author useruseruser12 
	 */
	public class GetWorkSheetSequenceCommand extends AbstractSequenceNotificationCommand
	{		
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		private var delegate:GetWorkSheetDelegate;
		private var loadEvent: LoadWorkSheetEvent;
		private var debug:Boolean = false;
		private var worksheetName:String = "";
		
		/**
		 * Constructor.  
		 */
		public function GetWorkSheetSequenceCommand()
		{
			super();
			if (Services(ServiceLocator.getInstance()).callMode == InitAppEvent.SERVICE_USE_MOCK) {
				debug = true;	
			}
			this.nextEvent = new LoadWorkSheetEvent(LoadWorkSheetEvent.EVENT_GET_WORKSHEET_SEQUENCE);
		}
		
		public override function execute(event:CairngormEvent):void
		{
			
			super.execute(event);
			
			delegate  = new GetWorkSheetDelegate(this);		
			loadEvent = LoadWorkSheetEvent(event);
			
			var worksheetID:String = loadEvent.worksheetID;
			worksheetName = loadEvent.worksheetName;
			
			//Alert.show("GetWorksheetViewCommand-> worksheet = " + worksheetName);
			
			delegate.getWorksheet(worksheetID,"1");
		}
		
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;			
			var nodeList:XMLList;
			
			if (debug && (worksheetName == "Assess")) {
				nodeList = xml.worksheet_test.worksheet;
			} else if (debug && (worksheetName == "Edit Closed")) {
				nodeList = xml.worksheet_test1.worksheet;
			} else {
				nodeList = xml.worksheet;
			}
			
			//var nodeList:XMLList = xml.worksheet;
			
			//Alert.show("GetWorksheetViewCommand-> result = " + xml);
			
			for each (var item: XML in nodeList) {
				
				var workSheetModel:WorkSheetModel = new WorkSheetModel(WorkSheetFactory.buildWorkSheet(item));				
				model.addWorksheetModel(workSheetModel);
				
			}		
			
			
			if(this.nextEvent != null) {
				
				var workSheetListVO:WorkSheetListVO = model.getNextRequiredWorksheet();
				
				if(workSheetListVO != null) {
					
					(this.nextEvent as LoadWorkSheetEvent).worksheetID = String(workSheetListVO.id);
					(this.nextEvent as LoadWorkSheetEvent).worksheetName = workSheetListVO.worksheetName;				
					this.executeNextCommand();
					
				} /* else {
					
					var loadEvent: LoadWorkSheetEvent = new LoadWorkSheetEvent(LoadWorkSheetEvent.EVENT_SWITCH_WORKSHEET);
					loadEvent.worksheetName = model.defaultRequiredWorksheet;
					loadEvent.dispatch();
				}*/
			}
			
			notifyCaller(data);
			
		}
		
		
		/**
		 * Message that is returned when a fault occurs.
		 * @param faultEvent - The event associated with the fault.
		 * @return String - The message.
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "GetWorkSheetSequenceCommand failed: " + super.getFaultMessage(faultEvent);
		}
		
		/**
		 * This method is called when a fault occurs.
		 * @param info The information regarding the fault.
		 * 
		 */
		override public function fault(info:Object):void
		{
			super.fault(info);
		}
		
	}
}