package gov.va.med.edp.command.worksheet
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.worksheet.GetSectionListDelegate;
	import gov.va.med.edp.business.worksheet.LoadWorkSheetDelegate;
	import gov.va.med.edp.business.worksheet.LoadWorkSheetListDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.control.worksheet.LoadWorkSheetEvent;
	import gov.va.med.edp.factory.WorkSheetFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.model.worksheet.SectionModel;
	import gov.va.med.edp.model.worksheet.WorkSheetModel;
	import gov.va.med.edp.vo.worksheet.SectionVO;
	import gov.va.med.edp.vo.worksheet.WorkSheetVO;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	
	/**
	 * Command to get all available sections. 
	 * @author Joseph Lemaire
	 */
	public class GetSectionListCommand extends AbstractResponderCommand implements ICommand, IResponder
	{		
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/**
		 * Constructor.  
		 */
		public function GetSectionListCommand()
		{
			//super();
		}
		
		public function execute(event:CairngormEvent):void
		{
			var delegate:GetSectionListDelegate = new GetSectionListDelegate(this);		
			var loadEvent: LoadWorkSheetEvent = LoadWorkSheetEvent(event);
			delegate.getSectionList(model.logArea, model.roleSelected);
		}
		
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;
			
			model.sectionList = xml.sections.section;

		}
		
		
		/**
		 * Message that is returned when a fault occurs.
		 * @param faultEvent - The event associated with the fault.
		 * @return String - The message.
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Getting section list failed: " + super.getFaultMessage(faultEvent);
		}
		
		/**
		 * This method is called when a fault occurs.
		 * @param info The information regarding the fault.
		 * 
		 */
		override public function fault(info:Object):void
		{
			super.fault(info);
		}
		
	}
}