package gov.va.med.edp.command.worksheet
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.worksheet.GetComponentListDelegate;
	import gov.va.med.edp.business.worksheet.GetSectionListDelegate;
	import gov.va.med.edp.business.worksheet.LoadWorkSheetDelegate;
	import gov.va.med.edp.business.worksheet.LoadWorkSheetListDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.control.worksheet.LoadWorkSheetEvent;
	import gov.va.med.edp.factory.WorkSheetFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.model.worksheet.SectionModel;
	import gov.va.med.edp.model.worksheet.WorkSheetModel;
	import gov.va.med.edp.vo.worksheet.SectionVO;
	import gov.va.med.edp.vo.worksheet.WorkSheetVO;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.utils.ObjectUtil;
	
	/**
	 * Command to get all available sections. 
	 * @author Joseph Lemaire
	 */
	public class GetComponentListCommand extends AbstractResponderCommand implements ICommand, IResponder
	{		
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/**
		 * Constructor.  
		 */
		public function GetComponentListCommand()
		{
			//super();
		}
		
		public function execute(event:CairngormEvent):void
		{
			model.artifactsLoaded = false;
			var delegate:GetComponentListDelegate = new GetComponentListDelegate(this);		
			var loadEvent: LoadWorkSheetEvent = LoadWorkSheetEvent(event);
			delegate.getComponentList(model.logArea, model.roleSelected);
		}
		
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;
			
			model.componentList = xml.components.component;
			
			model.artifactsLoaded = true;
			
			var debug:Boolean = false;
			
			if (!debug) {
				return;
			}
			
			var attributes:XMLList;
			var attribute:XML;
			var s:String = "";
			var node:XML;
			var k:int;
			var counter:int = 0;
			for each (node in model.componentList) {
				attributes = node.attributes();
				for( k = 0; k < attributes.length(); k++ ) {
					attribute = attributes[ k ];
					if (s.length > 1) 
						s += "^";
					s += attribute.name();
				}
				trace(s);
				break;
			}
			for each (node in model.componentList) {
				attributes = node.attributes();
				s = "";
				counter++;
				for( k = 0; k < attributes.length(); k++ )
				{
					attribute = attributes[ k ];
					if (s.length >= 1) 
						s += "^";
					if (attribute.name() == "id") {
						s += counter;
					}
					else if (attribute.name() == "sequence") {
						s += "0";
					}
					else {
						s += attribute;
					}
				}
				trace(s);
				trace(ObjectUtil.toString( node.children() ) );
			}
			
		}
		
		
		/**
		 * Message that is returned when a fault occurs.
		 * @param faultEvent - The event associated with the fault.
		 * @return String - The message.
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Getting component list failed: " + super.getFaultMessage(faultEvent);
		}
		
		/**
		 * This method is called when a fault occurs.
		 * @param info The information regarding the fault.
		 * 
		 */
		override public function fault(info:Object):void
		{
			super.fault(info);
		}
		
	}
}