package gov.va.med.edp.command.worksheet
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;
	
	import gov.va.med.edp.business.worksheet.LoadWorkSheetListDelegate;
	import gov.va.med.edp.command.AbstractSequenceCommand;
	import gov.va.med.edp.control.TrackingEvent;
	import gov.va.med.edp.control.worksheet.LoadWorkSheetEvent;
	import gov.va.med.edp.factory.WorkSheetFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.utils.ObjectUtil;
	
	/**
	 * The command to perform the action of getting worksheet artifacts (sections, components, etc).
	 */
	public class GetArtifactsCommand extends AbstractSequenceCommand implements IResponder
	{
		
		private namespace self;
		private var viewHandlers  : IResponder = null;
		
		
		/*
		* The EDIS model state.
		*/
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		private var loadEvent : LoadWorkSheetEvent;
		
		/**
		 * Constructor.
		 */
		public function GetArtifactsCommand() 
		{	
		}
		
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		override public function execute( event:CairngormEvent ) : void
		{
			model.roleWorksheetLoaded = false;

			
			cacheCaller(event);
			
			loadEvent = LoadWorkSheetEvent( event );
			
			var delegate:LoadWorkSheetListDelegate = new LoadWorkSheetListDelegate(this);
			var role:String = loadEvent.role;
			delegate.loadWorksheetList(model.logArea, role);
			
		}
		
		/**
		 * Process the results of the VistA RPC call
		 * @param The data object from the parent 
		 */
		override public function result(data:Object):void
		{
			
			var xml:XML = ResultEvent(data).result as XML;
			
			var nodeList:XMLList = xml.worksheets.role;
			
			model.roleWorksheets = WorkSheetFactory.buildRoleWorksheet(nodeList);
			
			this.nextEvent = new LoadWorkSheetEvent(LoadWorkSheetEvent.EVENT_GET_SECTION_LIST);
			this.executeNextCommand();
			
			this.nextEvent = new LoadWorkSheetEvent(LoadWorkSheetEvent.EVENT_GET_COMPONENT_LIST);
			this.executeNextCommand();
			
			notifyCaller(data);		
			
			model.roleWorksheetLoaded = true;

		}
		
		/**
		 * Retrieve the failt message. 
		 * @param faultEvent
		 * @return 
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Getting worksheet artifacts failed: " + super.getFaultMessage(faultEvent);
		}
		/**
		 *  This method is called by a service when an error has been received.
		 *  While <code>info</code> is typed as Object it is often
		 *  (but not always) an mx.rpc.events.FaultEvent.
		 */
		public override function fault(info:Object):void
		{
			notifyCaller(info);
			super.fault(info);
		}
		
		private function cacheCaller(event:Event):void {
			viewHandlers = getResponderFor(event);
		}
		
		private function getResponderFor(event:Event):IResponder {
			var results : IResponder = null;
			if (event != null) {
				if (event is TrackingEvent){
					results = (event as TrackingEvent).callbacks;
				}
			}
			return results;
		}
		
		self function result(info:Object):void {
			if (viewHandlers && (viewHandlers.result != null)) {
				viewHandlers.result(info);
			}
		}
		
		self function fault( info:Object ) : void {
			if (viewHandlers && (viewHandlers.fault != null)) {
				viewHandlers.fault(info);
			}
		}
		
		public function notifyCaller(results:* = null):void {
			if (results is FaultEvent) {
				self::fault(results);
			}
			else{
				self::result(results);
			}
		}
	}	
}