package gov.va.med.edp.command.reports.adhoc
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.reports.adhoc.SaveAdhocReportDelegate;
	import gov.va.med.edp.command.AbstractNotificationCommand;
	import gov.va.med.edp.control.reports.adhoc.ReportSaveEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.controls.Alert;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import gov.va.med.edp.factory.ReportFactory;
	import mx.collections.ArrayCollection;
	import gov.va.med.edp.vo.reports.adhoc.AdhocReportVO;
	
	/**
	 * Save a given ad-hoc report
	 * @author useruseruser12
	 * 
	 */
	public class SaveAdhocReportCommand extends AbstractNotificationCommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		private var delegate:SaveAdhocReportDelegate;
		public var saveEvent: ReportSaveEvent;
		
		/**
		 * 
		 * 
		 */
		public function SaveAdhocReportCommand()
		{
			super();
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		public override function execute(event:CairngormEvent):void
		{
			super.execute(event);
			
			delegate = new SaveAdhocReportDelegate(this);
			saveEvent = ReportSaveEvent(event);	
			
			if(saveEvent.area == 0) {
				throw new Error("Attempted to execute SaveAdhocReportCommand with a 0 area.");
			}
			
			if(saveEvent.type == ReportSaveEvent.EVENT_SAVE_ADHOC_REPORT) {
				
				delegate.saveAdhocReport(saveEvent.area,
					saveEvent.id,
					false,
					saveEvent.name,
					saveEvent.elements,
					saveEvent.inactive,
					saveEvent.editable,
					saveEvent.role);
				
				//Alert.show("SaveAdhocReportCommand SAVE , area = " + saveEvent.area + " , id = " + saveEvent.id + " , name = " + saveEvent.name + " , elements = " + saveEvent.elements);
				
			} else if (saveEvent.type == ReportSaveEvent.EVENT_SAVE_AS_ADHOC_REPORT) {
				
				delegate.saveAdhocReport(saveEvent.area,
					saveEvent.id,
					false,
					saveEvent.name,
					saveEvent.elements,
					saveEvent.inactive,
					saveEvent.editable,
					saveEvent.role);
				
				//Alert.show("SaveAdhocReportCommand SAVE_AS , area = " + saveEvent.area + " , id = " + saveEvent.id + " , name = " + saveEvent.name + " , elements = " + saveEvent.elements);				
			} else {
			
				
				delegate.deleteAdhocReport(saveEvent.area,
					saveEvent.id);
				
				//Alert.show("SaveAdhocReportCommand DELETE , area = " + saveEvent.area + " , id = " + saveEvent.id + " , name = " + saveEvent.name);
			} 
			
			

		}
		
		/**
		 * 
		 * @param data
		 * 
		 */
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;						
			
			
			if(saveEvent.type == ReportSaveEvent.EVENT_DELETE_ADHOC_REPORT) {
				
				if(xml.status == "deleted") {									
					model.currentAdhocReport = null;								 
					model.currentAdhocReportRoleList = new ArrayCollection();
					model.currentAdhocReportElementList = new ArrayCollection();
					notifyCaller(data);
				}
				
			} else {
			
				var adhocReports: ArrayCollection = ReportFactory.buildAdhocReportListFromXML(xml.reports.report);
			
				model.currentAdhocReport = (adhocReports.getItemAt(0) as AdhocReportVO);								 
				model.currentAdhocReportRoleList = model.currentAdhocReport.rolesVO;
				model.currentAdhocReportElementList = model.currentAdhocReport.elementsVO;
			
				//Alert.show("SaveAdhocReportCommand currentAdhocReport:\n" + model.currentAdhocReport
				//				+ "\n\nmodel.currentAdhocReportRoleList:\n" + model.currentAdhocReportRoleList + "\n\nmodel.currentAdhocReportElementList:\n" + model.currentAdhocReportElementList);
			
				model.reportElementsLoaded = true;
				notifyCaller(data);
			}
			
			
		}
		
		
		/**
		 * Message that is returned when a fault occurs.
		 * @param faultEvent - The event associated with the fault.
		 * @return String - The message.
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "SaveAdhocReportCommand failed: " + super.getFaultMessage(faultEvent);
		}
		
		/**
		 * This method is called when a fault occurs.
		 * @param info The information regarding the fault.
		 * 
		 */
		override public function fault(info:Object):void
		{
			super.fault(info);
		}
	}
}