package gov.va.med.edp.command.reports.adhoc
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.reports.adhoc.LoadAdhocReportListDelegate;
	import gov.va.med.edp.command.AbstractNotificationCommand;
	import gov.va.med.edp.control.reports.adhoc.ReportListEvent;
	import gov.va.med.edp.factory.ReportFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.reports.adhoc.AdhocReportVO;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.controls.Alert;
	
	
	/**
	 * Load a given ad-hoc report
	 * @author useruseruser12
	 * 
	 */
	public class LoadAdhocReportListCommand extends AbstractNotificationCommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		private var delegate:LoadAdhocReportListDelegate;
		public var getEvent: ReportListEvent;
		
		/**
		 * 
		 * 
		 */
		public function LoadAdhocReportListCommand()
		{
			super();
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		public override function execute(event:CairngormEvent):void
		{
			super.execute(event);
			
			delegate = new LoadAdhocReportListDelegate(this);
			getEvent = ReportListEvent(event);	
			
			if(getEvent.area == 0) {
				throw new Error("Attempted to execute LoadAdhocReportListCommand with a 0 area.");
			}
			
			if(getEvent.type == ReportListEvent.EVENT_GET_BASIC_REPORT_LIST) {
				
				delegate.loadAdhocReportList(getEvent.area);
				
			} else {
				model.reportElementsLoaded = false;
				delegate.loadAdhocReportList(getEvent.area,getEvent.id,getEvent.elements);
			}
			
//			Alert.show("LoadAdhocReportListCommand , area = " + getEvent.area + " , id = " + getEvent.id + " , elements = " + getEvent.elements);

		}
		
		/**
		 * 
		 * @param data
		 * 
		 */
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;		
			
//			Alert.show("LoadAdhocReportListCommand type " + getEvent.type + " : result xml " + xml);
			
			if(getEvent.type == ReportListEvent.EVENT_GET_BASIC_REPORT_LIST) {
			
				model.adhocReportList = ReportFactory.buildAdhocReportListFromXML(xml.reports.report);
							
			} else {
				
				var adhocReports: ArrayCollection = ReportFactory.buildAdhocReportListFromXML(xml.reports.report);

				model.currentAdhocReport = (adhocReports.getItemAt(0) as AdhocReportVO);								 
				model.currentAdhocReportRoleList = model.currentAdhocReport.rolesVO;
				model.currentAdhocReportElementList = model.currentAdhocReport.elementsVO;
				
//				Alert.show("LoadAdhocReportListCommand currentAdhocReport:\n" + model.currentAdhocReport
//					+ "\n\nmodel.currentAdhocReportRoleList:\n" + model.currentAdhocReportRoleList + "\n\nmodel.currentAdhocReportElementList:\n" + model.currentAdhocReportElementList);
				
				model.reportElementsLoaded = true;
				//model.currentAdhocReportRoleList = ReportFactory.buildAdhocReportRoleListFromXML(xml.reports.report.role);
				//model.currentAdhocReportElementList = ReportFactory.buildAdhocReportElementListFromXML(xml.reports.report.element);					
			}
						
			notifyCaller(data);
		}
		
		
		/**
		 * Message that is returned when a fault occurs.
		 * @param faultEvent - The event associated with the fault.
		 * @return String - The message.
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "LoadAdhocReportListCommand failed: " + super.getFaultMessage(faultEvent);
		}
		
		/**
		 * This method is called when a fault occurs.
		 * @param info The information regarding the fault.
		 * 
		 */
		override public function fault(info:Object):void
		{
			super.fault(info);
		}
	}
}