package gov.va.med.edp.command.reports.adhoc
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.reports.CustomReportDelegate;
	import gov.va.med.edp.command.AbstractNotificationCommand;
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.control.reports.adhoc.ReportExecuteEvent;
	import gov.va.med.edp.factory.ReportFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.controls.Alert;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import flash.net.FileReference;
	import gov.va.med.edp.widget.InfoDialog;
	import flash.events.Event;
	
	import flash.events.IOErrorEvent;
	
	/**
	 * Execute a specific ad-hoc report
	 * @author useruseruser12
	 * 
	 */
	public class ExecuteAdhocReportCommand extends AbstractNotificationCommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		private var delegate:CustomReportDelegate;
		public var searchEvent: ReportExecuteEvent;
		private var fr:FileReference = new FileReference();

		
		/**
		 * 
		 * 
		 */
		public function ExecuteAdhocReportCommand()
		{
			super();
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		public override function execute(event:CairngormEvent):void
		{
			super.execute(event);
			
			fr.addEventListener(Event.OPEN, openHandler);
			fr.addEventListener(IOErrorEvent.IO_ERROR, errorHandler);
			fr.addEventListener(Event.COMPLETE, completeHandler);	
			
			delegate = new CustomReportDelegate(this);
			searchEvent = ReportExecuteEvent(event);	
			
			
			//if (searchEvent.type == ReportExecuteEvent.EVENT_EXPORT_ADHOC_REPORT ) {
				
			//	delegate.csvCustomReport(searchEvent.searchParams);
				
			//} else {
			
				delegate.executeAdhocReport(searchEvent.searchParams);	
			
				if (searchEvent.searchParams.startDate != null && searchEvent.searchParams.endDate != null)
				{
					model.reports.startDate = searchEvent.searchParams.startDate;
					model.reports.stopDate = searchEvent.searchParams.endDate;
				}
				
				if (searchEvent.searchParams.patient != null)
				{
					model.reports.patient = searchEvent.searchParams.patient;
				}
			
				if (searchEvent.searchParams.resident != null)
				{
					model.reports.resident = searchEvent.searchParams.resident;
				}
				
			//}
		
		}
		
		/**
		 * 
		 * @param data
		 * 
		 */
		override public function result(data:Object):void
		{
								
			var xml:XML = ResultEvent(data).result as XML;
			
			if (searchEvent.type == ReportExecuteEvent.EVENT_EXPORT_ADHOC_REPORT ) {
				
				var fileName:String;
				
				if(model.currentAdhocReport != null) {
					fileName = model.currentAdhocReport.name + "Report.xls";	
				} else {
					fileName = "AdhocReport.xls";
				}
					
				
				var cvs:String = xml.logEntries;
				
				//FileReference.
				
				//fr.download(cvs, fileName);
				
				
				
			} else {
				
				
				
				model.adhocReportContent = new XMLList(xml.logEntries);				
				//fire the binding..
				model.reports.reportType = "";
				model.reports.reportType = ReportEvent.EVENT_CUSTOM_REPORT;
								
			}
						
			notifyCaller(data);
		}
		
		
		/**
		 * Message that is returned when a fault occurs.
		 * @param faultEvent - The event associated with the fault.
		 * @return String - The message.
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "ExecuteAdhocReportCommand failed: " + super.getFaultMessage(faultEvent);
		}
		
		/**
		 * This method is called when a fault occurs.
		 * @param info The information regarding the fault.
		 * 
		 */
		override public function fault(info:Object):void
		{
			super.fault(info);
		}
		
		private function completeHandler(event:Event):void {
			InfoDialog.show("Download Complete");
		}
		
		private function errorHandler(event:Event):void {
			InfoDialog.show("An error occured while downloading the file" + event.currentTarget.toString());
		}
		
		private function openHandler(event:Event):void {
			trace("Dialog Opened");
		}
	}
}
