
package gov.va.med.edp.command.reports.adhoc
{
	import com.adobe.cairngorm.business.ServiceLocator;
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.net.FileReference;
	import flash.net.URLRequest;
	
	import gov.va.med.edp.business.CSPService;
	import gov.va.med.edp.control.reports.ReportDownloadEvent;
	import gov.va.med.edp.control.reports.adhoc.ReportExecuteEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.Vista;
	import gov.va.med.edp.vo.reports.adhoc.AdhocReportSearchParametersVO;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.controls.Alert;
	
	/**
	 * This command class communicates with the VistA RPC to download an ad-hoc report.
	 * 
	 */
	public class DownloadAdhocReportCommand implements ICommand
	{	
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();

		private var fr:FileReference = new FileReference();
		
		/**
		 *   Constructor.
		 */
		public function DownloadAdhocReportCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
            fr.addEventListener(Event.OPEN, openHandler);
            fr.addEventListener(IOErrorEvent.IO_ERROR, errorHandler);
            fr.addEventListener(Event.COMPLETE, completeHandler);	

			var reportEvent: ReportExecuteEvent = ReportExecuteEvent(event);
			
			var searchParams:AdhocReportSearchParametersVO = reportEvent.searchParams; 
			
			var service:CSPService = ServiceLocator.getInstance().getHTTPService("downloadAdhocReports") as CSPService;
			var startFMDate:String = Vista.DatetoFM(model.reports.startDate);
			var endFMDate:String = Vista.DatetoFM(model.reports.stopDate);
			
			var patient:String = model.reports.patient;
			
			var id:String = searchParams.id;
			
			var reportName:String = searchParams.reportName;
			
			var area:int = searchParams.area;
			
			var elements:String = "";
			
			var counter:int = 0;
			var seq:int;
			
			for each (var s:String in searchParams.elements) {
				elements = elements + "&element_" + counter++;
				elements = elements + "=" + s; //params["element_"+counter++] = s;
			}
			
			
			var urlPrefix:String = "";
			
			if (service.callType == CSPService.SERVICE_USE_VLJ){
				urlPrefix = service.vlj;
			} else if (service.callType == CSPService.SERVICE_USE_CSP){
				urlPrefix = service.csp;
			}
			
			var completeUrl: String = urlPrefix + "?command=" + service.command + "&edp=EDPGLOB" + "%20" + "RPC" + "&patient=" + patient + 
				elements + "&csv=true" + "&start=" + startFMDate + "&stop=" + endFMDate + "&id=" + id + "&area="+ area;
						
			//Alert.show("urlPrefix : " + urlPrefix);
			//Alert.show("completeUrl : " + completeUrl);
			
            var request:URLRequest = new URLRequest(completeUrl);
            var fileName:String = reportName + "Report.xls";

           fr.download(request, fileName);
 				
		}

        private function completeHandler(event:Event):void {
			InfoDialog.show("Download Complete");
        }
        
        private function errorHandler(event:Event):void {
			InfoDialog.show("An error occured while downloading the file" + event.currentTarget.toString());
        }
        
        private function openHandler(event:Event):void {
			trace("Dialog Opened");
        }


	}
}