package gov.va.med.edp.command.reports
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.reports.ReportElementDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.control.reports.adhoc.ReportElementEvent;
	import gov.va.med.edp.factory.ReportFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.utils.ObjectUtil;
	import mx.controls.Alert;
	
	/**
	 * Command to load worksheets per role. 
	 * @author Joseph Lemaire
	 */
	public class ReportElementCommand extends AbstractResponderCommand implements ICommand, IResponder
	{		
		protected var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		protected var delegate:ReportElementDelegate;
		protected var loadEvent: ReportElementEvent;
		
		/**
		 * Constructor.  
		 */
		public function ReportElementCommand()
		{
			//super();
		}
		
		public function execute(event:CairngormEvent):void
		{
			model.reportElementsLoaded = false;
			
			delegate = new ReportElementDelegate(this);		
			loadEvent = ReportElementEvent(event);
			delegate.reportElements();
		}
		
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;
			
			var nodeList:XMLList = xml.reportElements.element;
			
//			model.reportElements = ReportFactory.buildReportElements(nodeList);
			model.reportElements = ReportFactory.buildAdhocReportElementListFromXML(nodeList);

			model.reportElementsLoaded = true;
//			trace( "\n----------------\n"+ObjectUtil.toString( model.reportElements ) + "\n-------------------\n");
		}
		
		
		/**
		 * Message that is returned when a fault occurs.
		 * @param faultEvent - The event associated with the fault.
		 * @return String - The message.
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Loading report elements failed: " + super.getFaultMessage(faultEvent);
		}
		
		/**
		 * This method is called when a fault occurs.
		 * @param info The information regarding the fault.
		 * 
		 */
		override public function fault(info:Object):void
		{
			super.fault(info);
		}
		
	}
}
