/* LoadActivityReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.reports.ReportDelegate;
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.factory.ReportFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to retrieve VA admission reports.
	 * 
	 */
	public class LoadVaAdmissionsReportCommand extends BaseReportCommand
	{
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
			//add log enteries to model
			model.reports.vaAdmissionsReport.admissionLogs = ReportFactory.buildReportLogEntriesFromXML(xml.logEntries.log);
			//add averages to model..
			model.reports.vaAdmissionsReport.admissionAverages = ReportFactory.buildReportAveragesFromXML(xml.averages.average);
									
			//fire the binding..
			model.reports.reportType = "";
			model.reports.reportType = ReportEvent.EVENT_VA_ADMISSIONS_REPORT;
		}
		
	}
}